/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.eclipse.microprofile.reactive.streams.operators.core.GraphImpl;
import org.eclipse.microprofile.reactive.streams.operators.core.InternalStages;
import org.eclipse.microprofile.reactive.streams.operators.core.Stages;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.eclipse.microprofile.reactive.streams.operators.spi.ToGraphable;
import org.reactivestreams.Publisher;

abstract class ReactiveStreamsGraphBuilder
implements ToGraphable {
    private final Stage stage;
    private final ReactiveStreamsGraphBuilder previous;

    ReactiveStreamsGraphBuilder(Stage stage, ReactiveStreamsGraphBuilder previous) {
        this.stage = stage;
        this.previous = previous;
    }

    public Graph toGraph() {
        ArrayDeque<Stage> deque = new ArrayDeque<Stage>();
        this.flatten(deque);
        return new GraphImpl(Collections.unmodifiableCollection(deque));
    }

    private void flatten(Deque<Stage> stages) {
        ReactiveStreamsGraphBuilder thisStage = this;
        while (thisStage != null) {
            if (thisStage.stage != InternalStages.Identity.INSTANCE) {
                if (thisStage.stage instanceof InternalStages.Nested) {
                    ((InternalStages.Nested)thisStage.stage).getBuilder().flatten(stages);
                } else if (thisStage.stage instanceof InternalStages.NestedGraph) {
                    Collection nestedStages = ((InternalStages.NestedGraph)thisStage.stage).getGraph().getStages();
                    ListIterator iter = nestedStages instanceof List ? ((List)nestedStages).listIterator(nestedStages.size()) : new ArrayList(nestedStages).listIterator(nestedStages.size());
                    while (iter.hasPrevious()) {
                        stages.addFirst((Stage)iter.previous());
                    }
                } else {
                    stages.addFirst(thisStage.stage);
                }
            }
            thisStage = thisStage.previous;
        }
    }

    static Graph rsBuilderToGraph(Object obj) {
        Objects.requireNonNull(obj);
        if (obj instanceof ToGraphable) {
            return ((ToGraphable)obj).toGraph();
        }
        throw new IllegalArgumentException(obj + " is not an instance of ToGraphable and so can't participate in this graph");
    }

    static Graph publisherToGraph(Publisher<?> publisher) {
        return new GraphImpl(Collections.singleton(new Stages.PublisherStage(publisher)));
    }
}

