/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3._private.Messages;
import org.xnio.Cancellable;
import org.xnio.FinishedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public final class ClientServiceHandle<T> {
    private final Attachments.Key<IoFuture<T>> key;
    private final String serviceName;
    private final Function<Channel, IoFuture<T>> constructor;
    private Channel channel;

    public ClientServiceHandle(String serviceName, Function<Channel, IoFuture<T>> constructor) {
        Messages.log.tracef("Creating ClientServiceHandle for service '%s':  %s", serviceName, this);
        this.key = new Attachments.Key<IoFuture>(IoFuture.class);
        this.serviceName = serviceName;
        this.constructor = constructor;
    }

    public IoFuture<T> getClientService(final Connection connection, OptionMap optionMap) {
        final Attachments attachments = connection.getAttachments();
        IoFuture existing = attachments.getAttachment(this.key);
        if (existing != null) {
            Messages.log.tracef("ClientServiceHandle %s ('%s') found existing service at connection %s", this, this.serviceName, connection);
            return existing;
        }
        FutureResult futureResult = new FutureResult((Executor)connection.getEndpoint().getXnioWorker());
        IoFuture future = futureResult.getIoFuture();
        existing = attachments.attachIfAbsent(this.key, future);
        if (existing != null) {
            Messages.log.tracef("ClientServiceHandle %s ('%s') found existing service at connection %s", this, this.serviceName, connection);
            return existing;
        }
        Messages.log.tracef("ClientServiceHandle %s ('%s') constructing future service at connection %s", this, this.serviceName, connection);
        IoFuture<Channel> futureChannel = connection.openChannel(this.serviceName, optionMap);
        futureChannel.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Channel, FutureResult<T>>(){

            public void handleCancelled(FutureResult<T> futureResult) {
                futureResult.setCancelled();
                attachments.removeAttachment(ClientServiceHandle.this.key, futureResult.getIoFuture());
            }

            public void handleFailed(IOException exception, FutureResult<T> futureResult) {
                futureResult.setException(exception);
                attachments.removeAttachment(ClientServiceHandle.this.key, futureResult.getIoFuture());
            }

            public void handleDone(final Channel channel, FutureResult<T> futureResult) {
                ClientServiceHandle.this.channel = channel;
                IoFuture nextFuture = (IoFuture)ClientServiceHandle.this.constructor.apply(channel);
                nextFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<T, FutureResult<T>>(){

                    public void handleCancelled(FutureResult<T> futureResult) {
                        IoUtils.safeClose((Closeable)channel);
                        futureResult.setCancelled();
                        Messages.log.tracef("ClientServiceHandle %s ('%s') cancelling service at connection %s", (Object)this, ClientServiceHandle.this.serviceName, connection);
                        attachments.removeAttachment(ClientServiceHandle.this.key, futureResult.getIoFuture());
                    }

                    public void handleFailed(IOException exception, FutureResult<T> futureResult) {
                        IoUtils.safeClose((Closeable)channel);
                        futureResult.setException(exception);
                        Messages.log.tracef("ClientServiceHandle %s ('%s') failed service at connection %s", (Object)this, ClientServiceHandle.this.serviceName, connection);
                        attachments.removeAttachment(ClientServiceHandle.this.key, futureResult.getIoFuture());
                    }

                    public void handleDone(T result, FutureResult<T> futureResult) {
                        futureResult.setResult(result);
                        attachments.replaceAttachment(ClientServiceHandle.this.key, futureResult.getIoFuture(), new FinishedIoFuture(result));
                        channel.addCloseHandler((closed, exception) -> {
                            Messages.log.tracef("ClientServiceHandle %s ('%s') closing service at connection %s", (Object)this, ClientServiceHandle.this.serviceName, connection);
                            attachments.removeAttachment(ClientServiceHandle.this.key);
                        });
                    }
                }, futureResult);
                futureResult.addCancelHandler((Cancellable)nextFuture);
            }
        }, (Object)futureResult);
        futureResult.addCancelHandler(futureChannel);
        return future;
    }

    public void closeChannel() throws IOException {
        IoUtils.safeClose((Closeable)this.channel);
    }
}

