/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.marshalling;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.infinispan.marshalling.MarshallerFactory;
import org.wildfly.clustering.infinispan.spi.marshalling.InfinispanProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ModuleClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;

public enum InfinispanMarshallerFactory implements BiFunction<ModuleLoader, List<Module>, Marshaller>
{
    LEGACY{
        private final Set<String> protoStreamModules = new HashSet<String>(Arrays.asList("org.wildfly.clustering.server", "org.wildfly.clustering.ejb.infinispan", "org.wildfly.clustering.web.infinispan"));
        private final Predicate<String> protoStreamPredicate = this.protoStreamModules::contains;

        @Override
        public Marshaller apply(ModuleLoader moduleLoader, List<Module> modules) {
            if (modules.stream().map(Module::getName).anyMatch(this.protoStreamPredicate)) {
                return (Marshaller)PROTOSTREAM.apply(moduleLoader, modules);
            }
            return (Marshaller)JBOSS.apply(moduleLoader, modules);
        }
    }
    ,
    JBOSS{

        @Override
        public Marshaller apply(ModuleLoader moduleLoader, List<Module> modules) {
            return (Marshaller)MarshallerFactory.JBOSS.apply((Object)moduleLoader, modules);
        }
    }
    ,
    PROTOSTREAM{

        @Override
        public Marshaller apply(ModuleLoader moduleLoader, final List<Module> modules) {
            return new InfinispanProtoStreamMarshaller((ClassLoaderMarshaller)new ModuleClassLoaderMarshaller(moduleLoader), new UnaryOperator<SerializationContextBuilder>(){

                @Override
                public SerializationContextBuilder apply(SerializationContextBuilder builder) {
                    for (Module module : modules) {
                        builder.load((ClassLoader)module.getClassLoader());
                    }
                    return builder;
                }
            });
        }
    };

}

