/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.streams.utils;

import io.smallrye.mutiny.helpers.StrictMultiSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class WrappedProcessor<T>
implements Processor<T, T> {
    private final Subscriber<T> subscriber;
    private final Publisher<T> publisher;
    private final AtomicBoolean subscribed = new AtomicBoolean(false);

    public WrappedProcessor(Subscriber<T> subscriber, Publisher<T> publisher) {
        this.subscriber = subscriber;
        this.publisher = publisher;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber);
        this.publisher.subscribe((Subscriber)new StrictMultiSubscriber(subscriber));
    }

    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription);
        if (!this.subscribed.compareAndSet(false, true)) {
            subscription.cancel();
        } else {
            this.subscriber.onSubscribe(subscription);
        }
    }

    public void onNext(T item) {
        this.subscriber.onNext(item);
    }

    public void onError(Throwable throwable) {
        this.subscriber.onError(Objects.requireNonNull(throwable));
    }

    public void onComplete() {
        this.subscriber.onComplete();
    }
}

