/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class AbstractAttributeDefinitionBuilder<BUILDER extends AbstractAttributeDefinitionBuilder, ATTRIBUTE extends AttributeDefinition> {
    private String name;
    private ModelType type;
    private String xmlName;
    private boolean allowNull;
    private boolean allowExpression;
    private ModelNode defaultValue;
    private MeasurementUnit measurementUnit;
    private String[] alternatives;
    private String[] requires;
    private ModelNode[] allowedValues;
    private ParameterCorrector corrector;
    private ParameterValidator validator;
    private boolean validateNull = true;
    private int minSize = 0;
    private boolean minSizeSet;
    private int maxSize = Integer.MAX_VALUE;
    private boolean maxSizeSet;
    private AttributeAccess.Flag[] flags;
    private AttributeMarshaller attributeMarshaller = null;
    private boolean resourceOnly = false;
    private DeprecationData deprecated = null;
    private AccessConstraintDefinition[] accessConstraints;
    private Boolean nullSignificant;
    private AttributeParser parser;
    private String attributeGroup;
    private CapabilityReferenceRecorder referenceRecorder;
    private Map<String, ModelNode> arbitraryDescriptors = null;
    private ModelNode undefinedMetricValue;
    private static AccessConstraintDefinition[] ZERO_CONSTRAINTS = new AccessConstraintDefinition[0];

    public AbstractAttributeDefinitionBuilder(String attributeName, ModelType type) {
        this(attributeName, type, false);
    }

    public AbstractAttributeDefinitionBuilder(String attributeName, ModelType type, boolean optional) {
        this.name = attributeName;
        this.type = type;
        this.allowNull = optional;
        this.xmlName = this.name;
    }

    public AbstractAttributeDefinitionBuilder(AttributeDefinition basis) {
        this(null, basis);
    }

    public AbstractAttributeDefinitionBuilder(String attributeName, AttributeDefinition basis) {
        this.name = attributeName != null ? attributeName : basis.getName();
        this.xmlName = basis.getXmlName();
        this.defaultValue = basis.getDefaultValue();
        this.type = basis.getType();
        this.allowNull = basis.isAllowNull();
        this.allowExpression = basis.isAllowExpression();
        this.measurementUnit = basis.getMeasurementUnit();
        this.corrector = basis.getCorrector();
        this.validator = basis.getValidator();
        this.alternatives = basis.getAlternatives();
        this.requires = basis.getRequires();
        this.attributeMarshaller = basis.getMarshaller();
        this.resourceOnly = basis.isResourceOnly();
        this.deprecated = basis.getDeprecationData();
        this.nullSignificant = basis.getNilSignificant();
        List<AccessConstraintDefinition> acl = basis.getAccessConstraints();
        this.accessConstraints = acl.toArray(new AccessConstraintDefinition[acl.size()]);
        this.parser = basis.getParser();
        Set<AttributeAccess.Flag> basisFlags = basis.getImmutableFlags();
        this.flags = basisFlags.toArray(new AttributeAccess.Flag[basisFlags.size()]);
        if (!basis.getAllowedValues().isEmpty()) {
            List<ModelNode> basisAllowedValues = basis.getAllowedValues();
            this.allowedValues = basisAllowedValues.toArray(new ModelNode[basisAllowedValues.size()]);
        }
        this.attributeGroup = basis.getAttributeGroup();
        if (!basis.getArbitraryDescriptors().isEmpty()) {
            this.arbitraryDescriptors = new HashMap<String, ModelNode>(basis.getArbitraryDescriptors());
        }
        this.referenceRecorder = basis.getReferenceRecorder();
    }

    public abstract ATTRIBUTE build();

    public BUILDER setXmlName(String xmlName) {
        this.xmlName = xmlName == null ? this.name : xmlName;
        return (BUILDER)this;
    }

    public BUILDER setRequired(boolean required) {
        this.allowNull = !required;
        return (BUILDER)this;
    }

    @Deprecated
    public BUILDER setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
        return (BUILDER)this;
    }

    public BUILDER setAllowExpression(boolean allowExpression) {
        this.allowExpression = allowExpression;
        return (BUILDER)this;
    }

    public BUILDER setDefaultValue(ModelNode defaultValue) {
        this.defaultValue = defaultValue == null || !defaultValue.isDefined() ? null : defaultValue;
        return (BUILDER)this;
    }

    public BUILDER setMeasurementUnit(MeasurementUnit unit) {
        this.measurementUnit = unit;
        return (BUILDER)this;
    }

    public BUILDER setCorrector(ParameterCorrector corrector) {
        this.corrector = corrector;
        return (BUILDER)this;
    }

    public BUILDER setValidator(ParameterValidator validator) {
        this.validator = validator;
        return (BUILDER)this;
    }

    public BUILDER setAlternatives(String ... alternatives) {
        this.alternatives = alternatives;
        return (BUILDER)this;
    }

    public BUILDER addAlternatives(String ... alternatives) {
        if (this.alternatives == null) {
            this.alternatives = alternatives;
        } else {
            String[] newAlternatives = Arrays.copyOf(this.alternatives, this.alternatives.length + alternatives.length);
            System.arraycopy(alternatives, 0, newAlternatives, this.alternatives.length, alternatives.length);
            this.alternatives = newAlternatives;
        }
        return (BUILDER)this;
    }

    public final BUILDER removeAlternatives(String ... alternatives) {
        if (this.alternatives == null) {
            return (BUILDER)this;
        }
        for (String alternative : alternatives) {
            if (!this.isAlternativePresent(alternative)) continue;
            int length = this.alternatives.length;
            String[] newAlternatives = new String[length - 1];
            int k = 0;
            for (String alt : this.alternatives) {
                if (alt.equals(alternative)) continue;
                newAlternatives[k] = alt;
                ++k;
            }
            this.alternatives = newAlternatives;
        }
        return (BUILDER)this;
    }

    private boolean isAlternativePresent(String alternative) {
        if (this.alternatives == null) {
            return false;
        }
        for (String alt : this.alternatives) {
            if (!alt.equals(alternative)) continue;
            return true;
        }
        return false;
    }

    public BUILDER addArbitraryDescriptor(String arbitraryDescriptor, ModelNode value) {
        if (this.arbitraryDescriptors == null) {
            this.arbitraryDescriptors = Collections.singletonMap(arbitraryDescriptor, value);
        } else {
            if (this.arbitraryDescriptors.size() == 1) {
                this.arbitraryDescriptors = new HashMap<String, ModelNode>(this.arbitraryDescriptors);
            }
            this.arbitraryDescriptors.put(arbitraryDescriptor, value);
        }
        return (BUILDER)this;
    }

    public Map<String, ModelNode> getArbitraryDescriptors() {
        return this.arbitraryDescriptors;
    }

    public BUILDER setRequires(String ... requires) {
        this.requires = requires;
        return (BUILDER)this;
    }

    public BUILDER setFlags(AttributeAccess.Flag ... flags) {
        this.flags = flags;
        return (BUILDER)this;
    }

    public BUILDER addFlag(AttributeAccess.Flag flag) {
        if (this.flags == null) {
            this.flags = new AttributeAccess.Flag[]{flag};
        } else {
            int i = this.flags.length;
            this.flags = Arrays.copyOf(this.flags, i + 1);
            this.flags[i] = flag;
        }
        return (BUILDER)this;
    }

    public BUILDER removeFlag(AttributeAccess.Flag flag) {
        if (!this.isFlagPresent(flag)) {
            return (BUILDER)this;
        }
        int length = this.flags.length;
        AttributeAccess.Flag[] newFlags = new AttributeAccess.Flag[length - 1];
        int k = 0;
        for (AttributeAccess.Flag flag1 : this.flags) {
            if (flag1 == flag) continue;
            newFlags[k] = flag1;
            ++k;
        }
        this.flags = newFlags;
        return (BUILDER)this;
    }

    protected boolean isFlagPresent(AttributeAccess.Flag flag) {
        if (this.flags == null) {
            return false;
        }
        for (AttributeAccess.Flag f : this.flags) {
            if (!f.equals((Object)flag)) continue;
            return true;
        }
        return false;
    }

    public BUILDER setStorageRuntime() {
        this.removeFlag(AttributeAccess.Flag.STORAGE_CONFIGURATION);
        return this.addFlag(AttributeAccess.Flag.STORAGE_RUNTIME);
    }

    public BUILDER setRuntimeServiceNotRequired() {
        return this.addFlag(AttributeAccess.Flag.RUNTIME_SERVICE_NOT_REQUIRED);
    }

    public BUILDER setRestartAllServices() {
        this.removeFlag(AttributeAccess.Flag.RESTART_NONE);
        this.removeFlag(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES);
        this.removeFlag(AttributeAccess.Flag.RESTART_JVM);
        return this.addFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES);
    }

    public BUILDER setRestartJVM() {
        this.removeFlag(AttributeAccess.Flag.RESTART_NONE);
        this.removeFlag(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES);
        this.removeFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES);
        return this.addFlag(AttributeAccess.Flag.RESTART_JVM);
    }

    public BUILDER setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.maxSizeSet = true;
        return (BUILDER)this;
    }

    Integer getConfiguredMaxSize() {
        return this.maxSizeSet ? Integer.valueOf(this.maxSize) : null;
    }

    public BUILDER setMinSize(int minSize) {
        this.minSize = minSize;
        this.minSizeSet = true;
        return (BUILDER)this;
    }

    Integer getConfiguredMinSize() {
        return this.minSizeSet ? Integer.valueOf(this.minSize) : null;
    }

    public BUILDER setAttributeMarshaller(AttributeMarshaller marshaller) {
        this.attributeMarshaller = marshaller;
        return (BUILDER)this;
    }

    public BUILDER setAttributeParser(AttributeParser parser) {
        this.parser = parser;
        return (BUILDER)this;
    }

    public BUILDER setResourceOnly() {
        this.resourceOnly = true;
        return (BUILDER)this;
    }

    public BUILDER setDeprecated(ModelVersion since) {
        return this.setDeprecated(since, true);
    }

    public BUILDER setDeprecated(ModelVersion since, boolean notificationUseful) {
        this.deprecated = new DeprecationData(since, notificationUseful);
        return (BUILDER)this;
    }

    public final BUILDER setExpressionsDeprecated() {
        return this.addFlag(AttributeAccess.Flag.EXPRESSIONS_DEPRECATED);
    }

    public BUILDER setAccessConstraints(AccessConstraintDefinition ... accessConstraints) {
        this.accessConstraints = accessConstraints;
        return (BUILDER)this;
    }

    public BUILDER addAccessConstraint(AccessConstraintDefinition accessConstraint) {
        if (this.accessConstraints == null) {
            this.accessConstraints = new AccessConstraintDefinition[]{accessConstraint};
        } else {
            this.accessConstraints = Arrays.copyOf(this.accessConstraints, this.accessConstraints.length + 1);
            this.accessConstraints[this.accessConstraints.length - 1] = accessConstraint;
        }
        return (BUILDER)this;
    }

    public BUILDER setNullSignificant(boolean nullSignificant) {
        this.nullSignificant = nullSignificant;
        return (BUILDER)this;
    }

    public BUILDER setAttributeGroup(String attributeGroup) {
        assert (attributeGroup == null || attributeGroup.length() > 0);
        this.attributeGroup = attributeGroup;
        return (BUILDER)this;
    }

    public BUILDER setAllowedValues(ModelNode ... allowedValues) {
        assert (allowedValues != null);
        this.allowedValues = allowedValues;
        return (BUILDER)this;
    }

    public BUILDER setAllowedValues(String ... allowedValues) {
        assert (allowedValues != null);
        this.allowedValues = new ModelNode[allowedValues.length];
        for (int i = 0; i < allowedValues.length; ++i) {
            this.allowedValues[i] = new ModelNode(allowedValues[i]);
        }
        return (BUILDER)this;
    }

    public BUILDER setAllowedValues(int ... allowedValues) {
        assert (allowedValues != null);
        this.allowedValues = new ModelNode[allowedValues.length];
        for (int i = 0; i < allowedValues.length; ++i) {
            this.allowedValues[i] = new ModelNode(allowedValues[i]);
        }
        return (BUILDER)this;
    }

    public BUILDER setCapabilityReference(String referencedCapability, RuntimeCapability<?> dependentCapability) {
        if (dependentCapability.isDynamicallyNamed()) {
            return this.setCapabilityReference(referencedCapability, dependentCapability.getName());
        }
        return this.setCapabilityReference(referencedCapability, dependentCapability.getName(), false);
    }

    public BUILDER setCapabilityReference(String referencedCapability) {
        this.referenceRecorder = new CapabilityReferenceRecorder.ContextDependencyRecorder(referencedCapability);
        return (BUILDER)this;
    }

    public BUILDER setCapabilityReference(String referencedCapability, AttributeDefinition ... dependantAttributes) {
        this.referenceRecorder = new CapabilityReferenceRecorder.CompositeAttributeDependencyRecorder(referencedCapability, dependantAttributes);
        return (BUILDER)this;
    }

    public BUILDER setCapabilityReference(RuntimeCapability capability, String referencedCapability, AttributeDefinition ... dependantAttributes) {
        this.referenceRecorder = new CapabilityReferenceRecorder.CompositeAttributeDependencyRecorder(capability, referencedCapability, dependantAttributes);
        return (BUILDER)this;
    }

    @Deprecated
    public BUILDER setCapabilityReference(String referencedCapability, String dependentCapability, boolean dynamicDependent) {
        this.referenceRecorder = new CapabilityReferenceRecorder.DefaultCapabilityReferenceRecorder(referencedCapability, dependentCapability, dynamicDependent);
        return (BUILDER)this;
    }

    public BUILDER setCapabilityReference(String referencedCapability, String dependentCapability) {
        this.referenceRecorder = new CapabilityReferenceRecorder.DefaultCapabilityReferenceRecorder(referencedCapability, dependentCapability);
        return (BUILDER)this;
    }

    public BUILDER setCapabilityReference(CapabilityReferenceRecorder referenceRecorder) {
        this.referenceRecorder = referenceRecorder;
        return (BUILDER)this;
    }

    public BUILDER setUndefinedMetricValue(ModelNode undefinedMetricValue) {
        this.undefinedMetricValue = undefinedMetricValue == null || !undefinedMetricValue.isDefined() ? null : undefinedMetricValue;
        return (BUILDER)this;
    }

    public String getName() {
        return this.name;
    }

    public ModelType getType() {
        return this.type;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public boolean isAllowExpression() {
        return this.allowExpression;
    }

    public ModelNode getDefaultValue() {
        return this.defaultValue;
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public String[] getAlternatives() {
        return this.copyStrings(this.alternatives);
    }

    public String[] getRequires() {
        return this.copyStrings(this.requires);
    }

    public ParameterCorrector getCorrector() {
        return this.corrector;
    }

    public ParameterValidator getValidator() {
        return this.validator;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public AttributeAccess.Flag[] getFlags() {
        return this.copyFlags(this.flags);
    }

    public AttributeMarshaller getAttributeMarshaller() {
        return this.attributeMarshaller;
    }

    public boolean isResourceOnly() {
        return this.resourceOnly;
    }

    public DeprecationData getDeprecated() {
        return this.deprecated;
    }

    public AccessConstraintDefinition[] getAccessConstraints() {
        return this.copyConstraints(this.accessConstraints);
    }

    public Boolean getNullSignificant() {
        return this.nullSignificant;
    }

    public ModelNode getUndefinedMetricValue() {
        return this.undefinedMetricValue;
    }

    public AttributeParser getParser() {
        return this.parser;
    }

    public String getAttributeGroup() {
        return this.attributeGroup;
    }

    public ModelNode[] getAllowedValues() {
        return this.allowedValues;
    }

    protected final CapabilityReferenceRecorder getCapabilityReferenceRecorder() {
        return this.referenceRecorder;
    }

    private String[] copyStrings(String[] toCopy) {
        if (toCopy == null) {
            return null;
        }
        String[] result = new String[toCopy.length];
        System.arraycopy(toCopy, 0, result, 0, toCopy.length);
        return result;
    }

    private AttributeAccess.Flag[] copyFlags(AttributeAccess.Flag[] toCopy) {
        if (toCopy == null) {
            return null;
        }
        AttributeAccess.Flag[] result = new AttributeAccess.Flag[toCopy.length];
        System.arraycopy(toCopy, 0, result, 0, toCopy.length);
        return result;
    }

    private AccessConstraintDefinition[] copyConstraints(AccessConstraintDefinition[] toCopy) {
        if (toCopy == null) {
            return null;
        }
        if (toCopy.length == 0) {
            return ZERO_CONSTRAINTS;
        }
        AccessConstraintDefinition[] result = new AccessConstraintDefinition[toCopy.length];
        System.arraycopy(toCopy, 0, result, 0, toCopy.length);
        return result;
    }
}

