/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public class SecurityKeyManager
extends X509ExtendedKeyManager {
    private X509KeyManager delegate;
    private String serverAlias;
    private String clientAlias;

    public SecurityKeyManager(X509KeyManager keyManager, String serverAlias, String clientAlias) {
        this.delegate = keyManager;
        this.serverAlias = serverAlias;
        this.clientAlias = clientAlias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this.clientAlias != null) {
            return this.clientAlias;
        }
        return this.delegate.chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.serverAlias != null) {
            return this.serverAlias;
        }
        return this.delegate.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.delegate.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.delegate.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegate.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.delegate.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
        if (this.delegate instanceof X509ExtendedKeyManager) {
            return ((X509ExtendedKeyManager)this.delegate).chooseEngineClientAlias(strings, principals, sslEngine);
        }
        return super.chooseEngineClientAlias(strings, principals, sslEngine);
    }

    @Override
    public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
        if (this.delegate instanceof X509ExtendedKeyManager) {
            return ((X509ExtendedKeyManager)this.delegate).chooseEngineServerAlias(s, principals, sslEngine);
        }
        return super.chooseEngineServerAlias(s, principals, sslEngine);
    }
}

