/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.jms.client.ConnectionFactoryOptions;
import org.hornetq.jms.client.HornetQJMSClientLogger;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.HornetQQueue;
import org.hornetq.jms.client.JMSExceptionHelper;
import org.hornetq.jms.client.SelectorTranslator;

public final class HornetQQueueBrowser
implements QueueBrowser {
    private final ConnectionFactoryOptions options;
    private final ClientSession session;
    private ClientConsumer consumer;
    private final HornetQQueue queue;
    private SimpleString filterString;

    protected HornetQQueueBrowser(ConnectionFactoryOptions options, HornetQQueue queue, String messageSelector, ClientSession session) throws JMSException {
        this.options = options;
        this.session = session;
        this.queue = queue;
        if (messageSelector != null) {
            this.filterString = new SimpleString(SelectorTranslator.convertToHornetQFilterString(messageSelector));
        }
    }

    public void close() throws JMSException {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (HornetQException e) {
                throw JMSExceptionHelper.convertFromHornetQException(e);
            }
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        try {
            this.close();
            this.consumer = this.session.createConsumer(this.queue.getSimpleAddress(), this.filterString, true);
            return new BrowserEnumeration();
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public String getMessageSelector() throws JMSException {
        return this.filterString == null ? null : this.filterString.toString();
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public String toString() {
        return "HornetQQueueBrowser->" + this.consumer;
    }

    private final class BrowserEnumeration
    implements Enumeration<HornetQMessage> {
        ClientMessage current = null;

        private BrowserEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            if (this.current == null) {
                try {
                    this.current = HornetQQueueBrowser.this.consumer.receiveImmediate();
                }
                catch (HornetQException e) {
                    return false;
                }
            }
            return this.current != null;
        }

        @Override
        public HornetQMessage nextElement() {
            if (this.hasMoreElements()) {
                ClientMessage next = this.current;
                this.current = null;
                HornetQMessage msg = HornetQMessage.createMessage(next, HornetQQueueBrowser.this.session, HornetQQueueBrowser.this.options);
                try {
                    msg.doBeforeReceive();
                }
                catch (Exception e) {
                    HornetQJMSClientLogger.LOGGER.errorCreatingMessage(e);
                    return null;
                }
                return msg;
            }
            throw new NoSuchElementException();
        }
    }
}

