/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

public class BundleDumper {
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int VERSION_3 = 3;
    private static final int BINARY_IN_BLOB_STORE = -1;
    private static final int BINARY_IN_DATA_STORE = -2;
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    public static final int UNDEFINED = 0;
    public static final int STRING = 1;
    public static final int BINARY = 2;
    public static final int LONG = 3;
    public static final int DOUBLE = 4;
    public static final int DATE = 5;
    public static final int BOOLEAN = 6;
    public static final int NAME = 7;
    public static final int PATH = 8;
    public static final int REFERENCE = 9;
    public static final int WEAKREFERENCE = 10;
    public static final int URI = 11;
    public static final int DECIMAL = 12;
    private static final String[] NAMES = new String[]{"undefined", "String", "Binary", "Long", "Double", "Date", "Boolean", "Name", "Path", "Reference", "WeakReference", "URI", "Decimal"};
    private StringBuilder buffer = new StringBuilder();
    private static final TimeZone[] COMMON_TIMEZONES = new TimeZone[]{TimeZone.getTimeZone("GMT+00:00"), TimeZone.getTimeZone("GMT+01:00"), TimeZone.getTimeZone("GMT+02:00"), TimeZone.getTimeZone("GMT+03:00"), TimeZone.getTimeZone("GMT+04:00"), TimeZone.getTimeZone("GMT+05:00"), TimeZone.getTimeZone("GMT+06:00"), TimeZone.getTimeZone("GMT+07:00"), TimeZone.getTimeZone("GMT+08:00"), TimeZone.getTimeZone("GMT+09:00"), TimeZone.getTimeZone("GMT+10:00"), TimeZone.getTimeZone("GMT+11:00"), TimeZone.getTimeZone("GMT+12:00"), TimeZone.getTimeZone("GMT+13:00"), TimeZone.getTimeZone("GMT+14:00"), TimeZone.getTimeZone("GMT+15:00"), TimeZone.getTimeZone("GMT-16:00"), TimeZone.getTimeZone("GMT-15:00"), TimeZone.getTimeZone("GMT-14:00"), TimeZone.getTimeZone("GMT-13:00"), TimeZone.getTimeZone("GMT-12:00"), TimeZone.getTimeZone("GMT-11:00"), TimeZone.getTimeZone("GMT-10:00"), TimeZone.getTimeZone("GMT-09:00"), TimeZone.getTimeZone("GMT-08:00"), TimeZone.getTimeZone("GMT-07:00"), TimeZone.getTimeZone("GMT-06:00"), TimeZone.getTimeZone("GMT-05:00"), TimeZone.getTimeZone("GMT-04:00"), TimeZone.getTimeZone("GMT-03:00"), TimeZone.getTimeZone("GMT-02:00"), TimeZone.getTimeZone("GMT-01:00")};
    private DataInputStream in;
    private int version;
    private final String[] namespaces = new String[]{"", null, null, null, null, null, null};
    static final UUID NULL_PARENT_ID = UUID.fromString("bb4e9d10-d857-11df-937b-0800200c9a66");

    public static void main(String ... args) throws IOException {
        new BundleDumper().run(args);
    }

    void run(String ... args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: java " + this.getClass().getName() + " <fileName>");
            System.out.println("where the file name points to a node bundle.");
            return;
        }
        RandomAccessFile f = new RandomAccessFile(args[0], "r");
        byte[] bundle = new byte[(int)f.length()];
        f.readFully(bundle);
        f.close();
        System.out.println(this.dump(bundle));
    }

    public String dump(byte[] bundle) throws IOException {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(bundle);
            this.in = new DataInputStream(bin);
            this.version = this.in.readUnsignedByte();
            this.buffer.append("version: ").append(this.version).append("\n");
            if (this.version >= 3) {
                this.readBundleNew();
            } else {
                this.readBundleOld();
            }
        }
        catch (Exception e) {
            this.buffer.append("\n");
            this.buffer.append("error: ").append(e.toString());
        }
        return this.buffer.toString();
    }

    private void readBundleNew() throws IOException {
        this.buffer.append("nodeTypeName: ").append(this.readName()).append("\n");
        UUID parentId = this.readNodeId();
        this.buffer.append("parentId: ").append(parentId).append("\n");
        if (NULL_PARENT_ID.equals(parentId)) {
            parentId = null;
            this.buffer.append("parentId is null\n");
        }
        this.buffer.append("modCount: ").append((short)this.readVarInt()).append("\n");
        int b = this.in.readUnsignedByte();
        this.buffer.append("referenceable: ").append((b & 1) != 0).append("\n");
        int mn = this.readVarInt(b >> 7 & 1, 1);
        if (mn == 1) {
            this.buffer.append("mixing type:").append(this.readName()).append("\n");
        } else if (mn > 1) {
            this.buffer.append("mixing type count:").append(mn).append("\n");
            for (int i = 0; i < mn; ++i) {
                this.buffer.append("mixing type:").append(this.readName()).append("\n");
            }
        }
        int pn = this.readVarInt(b >> 4 & 7, 7);
        for (int i = 0; i < pn; ++i) {
            this.buffer.append("property: ").append(this.readName()).append("\n");
            this.readPropertyEntry();
        }
        int nn = this.readVarInt(b >> 2 & 3, 3);
        for (int i = 0; i < nn; ++i) {
            this.buffer.append("child node: ").append(this.readQName()).append(" id: ").append(this.readNodeId()).append("\n");
        }
        int sn = this.readVarInt(b >> 1 & 1, 1);
        if (sn == 1) {
            this.buffer.append("shared set:").append(this.readNodeId()).append("\n");
        } else if (sn > 1) {
            this.buffer.append("shared set count:").append(sn).append("\n");
            for (int i = 0; i < sn; ++i) {
                this.buffer.append("shared set:").append(this.readNodeId()).append("\n");
            }
        }
    }

    private void readBundleOld() throws IOException {
        UUID parentId;
        int a = this.in.readUnsignedByte();
        int b = this.in.readUnsignedByte();
        int c = this.in.readUnsignedByte();
        String uri = "#" + (a << 16 | b << 8 | c);
        String local = "#" + this.in.readInt();
        this.buffer.append("nodeTypeName: ").append(uri).append(":").append(local).append("\n");
        this.buffer.append("parentUUID: ").append(this.readNodeId()).append("\n");
        this.buffer.append("definitionId: ").append(this.in.readUTF()).append("\n");
        String name = this.readIndexedQName();
        if (name != null) {
            do {
                this.buffer.append("mixin: ").append(name).append("\n");
            } while ((name = this.readIndexedQName()) != null);
        } else {
            this.buffer.append("mixins: -\n");
        }
        name = this.readIndexedQName();
        while (name != null) {
            this.buffer.append("property: ").append(name).append("\n");
            this.readPropertyEntry();
            name = this.readIndexedQName();
        }
        this.buffer.append("referenceable: ").append(this.in.readBoolean()).append("\n");
        UUID childId = this.readNodeId();
        while (childId != null) {
            this.buffer.append("childId: ").append(childId).append(" ").append(this.readQName()).append("\n");
            childId = this.readNodeId();
        }
        if (this.version >= 1) {
            this.buffer.append("modCount: ").append(this.in.readShort()).append("\n");
        }
        if (this.version >= 2 && (parentId = this.readNodeId()) != null) {
            do {
                this.buffer.append("shared set parentId: ").append(parentId).append("\n");
            } while ((parentId = this.readNodeId()) != null);
        }
    }

    private static String getType(int type) {
        try {
            return NAMES[type];
        }
        catch (Exception e) {
            return "unknown type " + type;
        }
    }

    private void readPropertyEntry() throws IOException {
        int type;
        int count = 1;
        if (this.version >= 3) {
            int b = this.in.readUnsignedByte();
            type = b & 0xF;
            this.buffer.append("  type: ").append(BundleDumper.getType(type)).append("\n");
            int len = b >>> 4;
            if (len != 0) {
                this.buffer.append("  multivalued\n");
                count = len == 15 ? this.readVarInt() + 15 - 1 : len - 1;
            }
            this.buffer.append("  modcount: ").append((short)this.readVarInt()).append("\n");
        } else {
            type = this.in.readInt();
            this.buffer.append("  modcount: ").append((short)(type >> 16 & 0xFFFF)).append("\n");
            this.buffer.append("  type: ").append(BundleDumper.getType(type &= 0xFFFF)).append("\n");
            boolean mv = this.in.readBoolean();
            if (mv) {
                this.buffer.append("  multivalued\n");
            }
            this.buffer.append("  definitionId: ").append(this.in.readUTF()).append("\n");
            count = this.in.readInt();
            if (count != 1) {
                this.buffer.append("  count: ").append(count).append("\n");
            }
        }
        block11: for (int i = 0; i < count; ++i) {
            switch (type) {
                case 2: {
                    int size = this.in.readInt();
                    if (size == -2) {
                        this.buffer.append("  value: binary in datastore: ").append(this.readString()).append("\n");
                        continue block11;
                    }
                    if (size == -1) {
                        this.buffer.append("  value: binary in blobstore: ").append(this.readString()).append("\n");
                        continue block11;
                    }
                    byte[] data = new byte[size];
                    this.in.readFully(data);
                    this.buffer.append("  value: binary: ").append(BundleDumper.convertBytesToHex(data)).append("\n");
                    continue block11;
                }
                case 4: {
                    this.buffer.append("  value: double: ").append(this.in.readDouble()).append("\n");
                    continue block11;
                }
                case 12: {
                    this.buffer.append("  value: double: ").append(this.readDecimal()).append("\n");
                    continue block11;
                }
                case 3: {
                    if (this.version >= 3) {
                        this.buffer.append("  value: varLong: ").append(this.readVarLong()).append("\n");
                        continue block11;
                    }
                    this.buffer.append("  value: long: ").append(this.in.readLong()).append("\n");
                    continue block11;
                }
                case 6: {
                    this.buffer.append("  value: boolean: ").append(this.in.readBoolean()).append("\n");
                    continue block11;
                }
                case 7: {
                    this.buffer.append("  value: name: ").append(this.readQName()).append("\n");
                    continue block11;
                }
                case 10: {
                    this.buffer.append("  value: weakreference: ").append(this.readNodeId()).append("\n");
                    continue block11;
                }
                case 9: {
                    this.buffer.append("  value: reference: ").append(this.readNodeId()).append("\n");
                    continue block11;
                }
                case 5: {
                    if (this.version >= 3) {
                        this.buffer.append("  value: date: ").append(this.readDate()).append("\n");
                        continue block11;
                    }
                }
                default: {
                    if (this.version >= 3) {
                        this.buffer.append("  value: string: ").append(this.readString()).append("\n");
                        continue block11;
                    }
                    int len = this.in.readInt();
                    byte[] bytes = new byte[len];
                    this.in.readFully(bytes);
                    this.buffer.append("  value: string: ").append(new String(bytes, StandardCharsets.UTF_8)).append("\n");
                }
            }
        }
    }

    private UUID readNodeId() throws IOException {
        if (this.version >= 3 || this.in.readBoolean()) {
            long msb = this.in.readLong();
            long lsb = this.in.readLong();
            return new UUID(msb, lsb);
        }
        return null;
    }

    private BigDecimal readDecimal() throws IOException {
        if (this.in.readBoolean()) {
            return new BigDecimal(this.readString());
        }
        return null;
    }

    private String readQName() throws IOException {
        if (this.version >= 3) {
            return this.readName();
        }
        String uri = "#" + this.in.readInt();
        String local = this.in.readUTF();
        return uri + ":" + local;
    }

    private String readIndexedQName() throws IOException {
        if (this.version >= 3) {
            return this.readName();
        }
        int index = this.in.readInt();
        if (index < 0) {
            return null;
        }
        String uri = "#" + index;
        String local = "#" + this.in.readInt();
        return uri + ":" + local;
    }

    private String readName() throws IOException {
        String uri;
        int b = this.in.readUnsignedByte();
        if ((b & 0x80) == 0) {
            return "indexToName #" + b;
        }
        int ns = b >> 4 & 7;
        if (ns < this.namespaces.length && this.namespaces[ns] != null) {
            uri = this.namespaces[ns];
        } else {
            uri = this.readString();
            if (ns < this.namespaces.length) {
                this.namespaces[ns] = uri;
            }
        }
        String local = new String(this.readBytes((b & 0xF) + 1, 16), StandardCharsets.UTF_8);
        return uri + ":" + local;
    }

    private int readVarInt() throws IOException {
        int b = this.in.readUnsignedByte();
        if ((b & 0x80) == 0) {
            return b;
        }
        return this.readVarInt() << 7 | b & 0x7F;
    }

    private int readVarInt(int value, int base) throws IOException {
        if (value < base) {
            return value;
        }
        return this.readVarInt() + base;
    }

    private long readVarLong() throws IOException {
        long b;
        long value = 0L;
        int bits = 0;
        do {
            b = this.in.readUnsignedByte();
            if (bits < 57) {
                value = (b & 0x7FL) << 57 | value >>> 7;
                bits += 7;
                continue;
            }
            value = (b & 1L) << 63 | value >>> 1;
            bits = 64;
        } while ((b & 0x80L) != 0L);
        if (((value >>>= 64 - bits) & 1L) != 0L) {
            return value >>> 1 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return value >>> 1;
    }

    private Calendar readDate() throws IOException {
        TimeZone tz;
        long ts = this.readVarLong();
        if ((ts & 1L) == 0L) {
            tz = COMMON_TIMEZONES[0];
            ts >>= 1;
        } else if ((ts & 2L) == 0L) {
            tz = COMMON_TIMEZONES[(int)ts >> 2 & 0x1F];
            ts >>= 7;
        } else {
            int m = (int)ts << 19 >> 21;
            int h = m / 60;
            String s = m < 0 ? String.format("GMT-%02d:%02d", -h, h * 60 - m) : String.format("GMT+%02d:%02d", h, m - h * 60);
            tz = TimeZone.getTimeZone(s);
            ts >>= 13;
        }
        int u = 0;
        int s = 0;
        int m = 0;
        int h = 0;
        int type = (int)ts & 3;
        ts >>= 2;
        switch (type) {
            case 3: {
                u = (int)ts & 0x3FFFFFFF;
                s = u / 1000;
                m = s / 60;
                h = m / 60;
                u -= ((h * 60 + m) * 60 + (s -= (h * 60 + (m -= h * 60)) * 60)) * 1000;
                ts >>= 30;
                break;
            }
            case 2: {
                m = (int)ts & 0x7FF;
                h = m / 60;
                m -= h * 60;
                ts >>= 11;
                break;
            }
            case 1: {
                h = (int)ts & 0x1F;
                ts >>= 5;
            }
        }
        int d = (int)ts & 0x1FF;
        int y = (int)((ts >>= 9) + 2010L);
        Calendar value = Calendar.getInstance(tz);
        if (y <= 0) {
            value.set(1, 1 - y);
            value.set(0, 0);
        } else {
            value.set(1, y);
            value.set(0, 1);
        }
        value.set(6, d);
        value.set(11, h);
        value.set(12, m);
        value.set(13, s);
        value.set(14, u);
        return value;
    }

    private String readString() throws IOException {
        if (this.version >= 3) {
            return new String(this.readBytes(0, 0), StandardCharsets.UTF_8);
        }
        return this.in.readUTF();
    }

    private byte[] readBytes(int len, int base) throws IOException {
        byte[] bytes = new byte[this.readVarInt(len, base)];
        this.in.readFully(bytes);
        return bytes;
    }

    public static String convertBytesToHex(byte[] value) {
        int len = value.length;
        char[] buff = new char[len + len];
        char[] hex = HEX;
        for (int i = 0; i < len; ++i) {
            int c = value[i] & 0xFF;
            buff[i + i] = hex[c >> 4];
            buff[i + i + 1] = hex[c & 0xF];
        }
        return new String(buff);
    }
}

