/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.model;

public enum OrderRowStatus {
    DOWNLOAD_REFUSED("R"),
    DOWNLOAD_DONE("T"),
    DOWNLOAD_ALLOWED("D"),
    DOWNLOAD_WITH_WATERMARK("DW"),
    TO_BE_DECIDED("");

    private final String code;

    private OrderRowStatus(String code) {
        this.code = code;
    }

    public static OrderRowStatus getStatusFromDownloadDecision(String downloadDecision) {
        if (OrderRowStatus.DOWNLOAD_REFUSED.code.equals(downloadDecision)) {
            return DOWNLOAD_REFUSED;
        }
        if (OrderRowStatus.DOWNLOAD_DONE.code.equals(downloadDecision)) {
            return DOWNLOAD_DONE;
        }
        if (OrderRowStatus.DOWNLOAD_ALLOWED.code.equals(downloadDecision)) {
            return DOWNLOAD_ALLOWED;
        }
        if (OrderRowStatus.DOWNLOAD_WITH_WATERMARK.code.equals(downloadDecision)) {
            return DOWNLOAD_WITH_WATERMARK;
        }
        return TO_BE_DECIDED;
    }
}

