<%--

    Copyright (C) 2000 - 2024 Silverpeas

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    As a special exception to the terms and conditions of version 3.0 of
    the GPL, you may redistribute this Program in connection with Free/Libre
    Open Source Software ("FLOSS") applications as described in Silverpeas's
    FLOSS exception.  You should have received a copy of the text describing
    the FLOSS exception, and it is also available here:
    "https://www.silverpeas.org/legal/floss_exception.html"

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

--%>
<%@page import="org.silverpeas.core.i18n.I18NHelper"%>
<%@page import="org.silverpeas.core.util.MultiSilverpeasBundle"%>
<%@page import="org.silverpeas.core.node.model.NodeDetail"%>
<%@page import="org.silverpeas.core.util.WebEncodeHelper"%>
<%@ page pageEncoding="UTF-8" contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://www.silverpeas.com/tld/viewGenerator" prefix="view"%>
<%@ page import="org.silverpeas.core.util.ResourceLocator" %>
<%@ page import="org.silverpeas.components.kmelia.control.KmeliaSessionController" %>
<c:url var="mandatoryFieldUrl" value="/util/icons/mandatoryField.gif"/>
<fmt:setLocale value="${sessionScope[sessionController].language}" />
<view:setBundle bundle="${requestScope.resources.multilangBundle}" />
<view:setBundle bundle="${requestScope.resources.iconsBundle}" var="icons" />
<% KmeliaSessionController kmeliaScc = (KmeliaSessionController) request.getAttribute("kmelia");%>
  <% if(kmeliaScc == null ) {
    // No session controller in the request -> security exception
    String sessionTimeout = ResourceLocator.getGeneralSettingBundle().getString("sessionTimeout");
    getServletConfig().getServletContext().getRequestDispatcher(sessionTimeout).forward(request, response);
    return;
    }
  %>
  <fmt:message var="cancelButtonLabel" key="GML.cancel"/>
  <fmt:message var="validateButtonLabel" key="GML.validate"/>
  <c:set var="node" value="${requestScope.NodeDetail}" scope="page"/>
  <%
  MultiSilverpeasBundle resources = (MultiSilverpeasBundle)request.getAttribute("resources");
  String translation = (String) request.getAttribute("Translation");
  String language = (String) request.getAttribute("Language");
  NodeDetail node = (NodeDetail) request.getAttribute("NodeDetail");
  String rightsSpecificChecked = "";
  String rightsInheritedChecked = "checked";
  if (node.haveLocalRights())
  {
      rightsSpecificChecked = "checked";
      rightsInheritedChecked = "";
  }
  String name  = "";
  String description  = "";
  if (node != null) {
      name = node.getName(language);
      description = node.getDescription(language);
  }

  %>
  <c:set var="userHasAdminAccess" value="<%=kmeliaScc.isTopicAdmin(node.getNodePK().getId())%>"/>
  <html>
    <head>
      <view:looknfeel withCheckFormScript="true"/>
      <title><fmt:message key="GML.popupTitle" /></title>
      <script type="text/javascript" src="<c:url value="/util/javaScript/i18n.js" />"></script>
      <script language="JavaScript" type="text/javascript">
        function topicGoTo(id)
        {
          location.href = "GoToTopic?Id="+id;
        }

        function cancelData()
        {
        <c:choose>
          <c:when test="${true eq requestScope.PopupDisplay}">
              window.close();
          </c:when>
          <c:otherwise>
              location.href = "GoToCurrentTopic";
          </c:otherwise>
        </c:choose>
          }

          function sendData() {
            var errorMsg = "";
            var errorNb = 0;
            var title = stripInitialWhitespace(document.topicForm.Name.value);
            if (isWhitespace(title)) {
              errorMsg+="  - '<fmt:message key="TopicTitle"/>' <fmt:message key="GML.MustBeFilled"/>\n";
              errorNb++;
            }
        <c:if test="${true eq requestScope.IsLink}">
            if (isWhitespace(stripInitialWhitespace(document.topicForm.Path.value))) {
              errorMsg+="  - '<fmt:message key="kmelia.Path"/>' <fmt:message key="GML.MustContainsText"/>\n";
              errorNb++;
            }
        </c:if>
            switch(errorNb)
            {
              case 0 :
                document.topicForm.submit();
                break;
              case 1 :
                errorMsg = "<fmt:message key="GML.ThisFormContains"/> 1 <fmt:message key="GML.error"/> : \n" + errorMsg;
                jQuery.popup.error(errorMsg);
                break;
              default :
                errorMsg = "<fmt:message key="GML.ThisFormContains"/> " + errorNb + " <fmt:message key="GML.errors"/> :\n" + errorMsg;
                jQuery.popup.error(errorMsg);
              }
            }
        <c:forEach items="${node.translations}" var="translation">
          <c:set var="lang" value="${translation.key}" scope="page"/>
          <%
          String lang = (String) pageContext.getAttribute("lang");
          out.println("var name_"+lang+" = \""+WebEncodeHelper.javaStringToJsString(node.getName(lang))+"\";\n");
          out.println("var desc_"+lang+" = \""+WebEncodeHelper.javaStringToJsString(node.getDescription(lang))+"\";\n");
          %>
        </c:forEach>


            function showTranslation(lang)
            {
              showFieldTranslation('nodeNameValue', 'name_'+lang);
              showFieldTranslation('nodeDesc', 'desc_'+lang);
            }

            function removeTranslation()
            {
              sendData();
            }
      </script>
    </head>
    <body>
      <fmt:message var="addTopicBrowseTitle" key="TopicUpdateTitle"/>
      <c:choose>
      	<c:when test="${true eq requestScope.PopupDisplay}">
      		<view:browseBar>
      			<view:browseBarElt id="${addTopicBrowseTitle}" label="${addTopicBrowseTitle}" link=""/>
      		</view:browseBar>
      	</c:when>
      	<c:otherwise>
      		<view:browseBar path="${requestScope.PathLinked}"/>
      	</c:otherwise>
      </c:choose>
      <view:window>
            <c:if test="${requestScope.Profiles != null and !empty requestScope.Profiles}">
              <view:tabs>
                <fmt:message var="defaultTabLabel" key="Theme" />
                <view:tab label="${defaultTabLabel}" action="#" selected="true" />
                <c:forEach items="${requestScope.Profiles}" var="theProfile" >
                  <c:url var="profileAction" value="ViewTopicProfiles"><c:param name="Id" value="${theProfile.id}"/><c:param name="Role" value="${theProfile.name}"/><c:param name="NodeId" value="${node.nodePK.id}"/></c:url>
                  <view:tab label="${theProfile.label}" action="${profileAction}" selected="false" />
                </c:forEach>
              </view:tabs>
            </c:if>
            <view:frame>
            <view:board>
            <form name="topicForm" action="UpdateTopic" method="POST">
              <table CELLPADDING="5" WIDTH="100%">
                <tr>
                  <td class="txtlibform"><fmt:message key="TopicPath"/>  :</td>
                  <td valign="top"><c:out value="${requestScope.Path}" escapeXml='false'/><input type="hidden" name="ChildId" value="<c:out value="${pageScope.node.id}"/>"></td>
                </tr>
                <%=I18NHelper.getFormLine(resources, node, translation)%>
                <tr>
                  <td class="txtlibform"><fmt:message key="TopicTitle"/> :</td>
                  <td><input type="text" name="Name" id="nodeNameValue" value="<%=WebEncodeHelper.javaStringToHtmlString(name)%>" size="60" maxlength="60" autofocus="autofocus">&nbsp;<img border="0" alt="mandatory" src="<c:out value="${mandatoryFieldUrl}" />" width="5" height="5"/></td>
                </tr>
                <c:choose>
                  <c:when test="${true eq requestScope.IsLink}">
                    <tr>
                      <td class="txtlibform"><fmt:message key="kmelia.Path"/> :</td>
                      <td><input type="text" name="Path" value="<c:out value="${node.path}"/>" size="60" maxlength="200">&nbsp;<img border="0" alt="mandatory" src="<c:out value="${mandatoryFieldUrl}" />" width="5" height="5"/></td>
                    </tr>
                  </c:when>
                  <c:otherwise>
                    <tr>
                      <td class="txtlibform"><fmt:message key="TopicDescription"/> :</td>
                      <td><input type="text" name="Description" id="nodeDesc" value="<%=WebEncodeHelper.javaStringToHtmlString(description)%>" size="60" maxlength="200"></td>
                    </tr>
                  </c:otherwise>
                </c:choose>
                <c:if test="${true eq requestScope.NotificationAllowed}">
                  <tr>
                    <td valign="top" class="txtlibform"><fmt:message key="TopicAlert" /> :</td>
                    <td valign="top">
                      <select name="AlertType">
                        <option value="NoAlert" selected="selected"><fmt:message key="NoAlert" /></option>
                        <option value="Publisher"><fmt:message key="OnlyPubsAlert" /></option>
                        <option value="All"><fmt:message key="AllUsersAlert" /></option>
                      </select>
                    </td>
                  </tr>
                </c:if>
                <c:if test="${requestScope.Profiles != null and !empty requestScope.Profiles}">
                <tr>
                  <td valign="top" class="txtlibform"><fmt:message key="kmelia.WhichTopicRightsUsed" /> :</td>
                  <td valign="top">
                    <table width="235" cellpadding="0" cellspacing="0">
                      <tr>
                        <td width="201"><fmt:message key="kmelia.RightsSpecific" /></td>
                        <td width="20"><input type="radio" value="<c:out value="${node.nodePK.id}"/>" name="RightsUsed" <%=rightsSpecificChecked%>></td>
                      </tr>
                      <tr>
                        <td width="201"><fmt:message key="kmelia.RightsInherited" /></td>
                        <td width="20"><input type="radio" value="-1" name="RightsUsed" <%=rightsInheritedChecked%>></td>
                      </tr>
                    </table>
                  </td>
                </tr>
                </c:if>
                <tr>
                  <td colspan="2"><img border="0" alt="<fmt:message key="GML.requiredField" />" src="<c:out value="${mandatoryFieldUrl}" />" width="5" height="5"/> : <fmt:message key="GML.requiredField" /></td>
                </tr>
              </table>
            </form>
          </view:board>
          <br/>
          <c:if test="${userHasAdminAccess}">
            <view:buttonPane>
              <view:button action="javascript:onClick=sendData();" label="${validateButtonLabel}" disabled="false"/>
              <view:button action="javascript:onClick=cancelData();" label="${cancelButtonLabel}" disabled="false"/>
            </view:buttonPane>
          </c:if>
        </view:frame>
      </view:window>
    </body>
  </html>