/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.subscription;

import java.util.Collection;
import java.util.HashSet;
import org.silverpeas.components.forums.model.Forum;
import org.silverpeas.components.forums.model.ForumPK;
import org.silverpeas.components.forums.model.Message;
import org.silverpeas.components.forums.model.MessagePK;
import org.silverpeas.components.forums.service.ForumsServiceProvider;
import org.silverpeas.components.forums.subscription.ForumMessageSubscription;
import org.silverpeas.components.forums.subscription.ForumMessageSubscriptionResource;
import org.silverpeas.components.forums.subscription.ForumSubscription;
import org.silverpeas.components.forums.subscription.ForumSubscriptionConstants;
import org.silverpeas.components.forums.subscription.ForumSubscriptionResource;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.subscription.SubscriberDirective;
import org.silverpeas.core.subscription.SubscriptionFactory;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.subscription.service.AbstractResourceSubscriptionService;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;

@Service
public class ForumsSubscriptionService
extends AbstractResourceSubscriptionService {
    public void init() throws Exception {
        super.init();
        SubscriptionFactory.get().register((SubscriptionResourceType)ForumSubscriptionConstants.FORUM, (r, s, i) -> new ForumSubscriptionResource(new ForumPK(i, r)), (s, r, c) -> new ForumSubscription(s, (ForumSubscriptionResource)r, c));
        SubscriptionFactory.get().register((SubscriptionResourceType)ForumSubscriptionConstants.FORUM_MESSAGE, (r, s, i) -> new ForumMessageSubscriptionResource(new MessagePK(i, r)), (s, r, c) -> new ForumMessageSubscription(s, (ForumMessageSubscriptionResource)r, c));
    }

    protected String getHandledComponentName() {
        return "forums";
    }

    public SubscriptionSubscriberList getSubscribersOfComponentAndTypedResource(String componentInstanceId, SubscriptionResourceType resourceType, String resourceId, SubscriberDirective ... directives) {
        SubscriptionResourceType nextTypeToHandle = resourceType;
        HashSet<SubscriptionSubscriber> subscribers = new HashSet<SubscriptionSubscriber>();
        ForumPK forumPK = new ForumPK(componentInstanceId, resourceId);
        if (nextTypeToHandle == ForumSubscriptionConstants.FORUM_MESSAGE) {
            MessagePK messagePK = new MessagePK(componentInstanceId, resourceId);
            Message message = this.verifyMessage(messagePK, subscribers);
            forumPK = new ForumPK(messagePK.getInstanceId(), message.getForumIdAsString());
            nextTypeToHandle = ForumSubscriptionConstants.FORUM;
        }
        if (nextTypeToHandle == ForumSubscriptionConstants.FORUM) {
            this.verifyForum(forumPK, subscribers);
            nextTypeToHandle = CommonSubscriptionResourceConstants.COMPONENT;
        }
        if (nextTypeToHandle == CommonSubscriptionResourceConstants.COMPONENT) {
            subscribers.addAll((Collection<SubscriptionSubscriber>)super.getSubscribersOfComponentAndTypedResource(componentInstanceId, CommonSubscriptionResourceConstants.COMPONENT, resourceId, new SubscriberDirective[0]));
        }
        return new SubscriptionSubscriberList(subscribers);
    }

    private void verifyForum(ForumPK forumPK, Collection<SubscriptionSubscriber> subscribers) {
        subscribers.addAll((Collection<SubscriptionSubscriber>)SubscriptionServiceProvider.getSubscribeService().getSubscribers((SubscriptionResource)ForumSubscriptionResource.from(forumPK)));
        Forum currentForum = ForumsServiceProvider.getForumsService().getForum(forumPK);
        while (!currentForum.isRoot()) {
            currentForum = ForumsServiceProvider.getForumsService().getForum(new ForumPK(forumPK.getInstanceId(), currentForum.getParentIdAsString()));
            subscribers.addAll((Collection<SubscriptionSubscriber>)SubscriptionServiceProvider.getSubscribeService().getSubscribers((SubscriptionResource)ForumSubscriptionResource.from(currentForum.getPk())));
        }
    }

    private Message verifyMessage(MessagePK messagePK, Collection<SubscriptionSubscriber> subscribers) {
        Message message;
        subscribers.addAll((Collection<SubscriptionSubscriber>)SubscriptionServiceProvider.getSubscribeService().getSubscribers((SubscriptionResource)ForumMessageSubscriptionResource.from(messagePK)));
        Message currentMessage = message = ForumsServiceProvider.getForumsService().getMessage(messagePK);
        while (!currentMessage.isSubject()) {
            currentMessage = ForumsServiceProvider.getForumsService().getMessage(new MessagePK(messagePK.getInstanceId(), currentMessage.getParentIdAsString()));
            subscribers.addAll((Collection<SubscriptionSubscriber>)SubscriptionServiceProvider.getSubscribeService().getSubscribers((SubscriptionResource)ForumMessageSubscriptionResource.from(currentMessage.getPk())));
        }
        return message;
    }
}

