/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.core.SilverpeasRuntimeException;
import org.silverpeas.core.admin.component.ComponentInstancePreDestruction;
import org.silverpeas.core.persistence.jdbc.DBUtil;

@Named
public class FormsOnlineInstancePreDestruction
implements ComponentInstancePreDestruction {
    private static final String USER_RIGHTS_DELETION = "delete from SC_FormsOnline_UserRights where instanceId = ?";
    private static final String GROUP_RIGHTS_DELETION = "delete from SC_FormsOnline_GroupRights where instanceId = ?";
    private static final String FORM_INSTANCES_DELETION = "delete from SC_FormsOnline_FormInstances where instanceId = ?";
    private static final String FORMS_DELETION = "delete from SC_FormsOnline_Forms where instanceId = ?";

    @Transactional
    public void preDestroy(String componentInstanceId) {
        try (Connection connection = DBUtil.openConnection();){
            this.deleteForms(connection, componentInstanceId);
        }
        catch (SQLException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private void deleteForms(Connection con, String componentId) {
        for (String deletion : Arrays.asList(USER_RIGHTS_DELETION, GROUP_RIGHTS_DELETION, FORM_INSTANCES_DELETION, FORMS_DELETION)) {
            try {
                PreparedStatement stmt = con.prepareStatement(deletion);
                try {
                    stmt.setString(1, componentId);
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            catch (SQLException e) {
                throw new SilverpeasRuntimeException("Cannot delete forms in " + componentId + " (query: " + deletion + ")", (Throwable)e);
            }
        }
    }
}

