/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mydb.service.impl;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.mydb.model.DataSourceDefinition;
import org.silverpeas.components.mydb.model.MyDBConnectionInfo;
import org.silverpeas.components.mydb.model.MyDBConnectionInfoRepository;
import org.silverpeas.components.mydb.service.MyDBConnectionInfoService;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;
import org.silverpeas.core.util.StringUtil;

@Service
@Transactional
public class SimpleMyDBConnectionInfoService
implements MyDBConnectionInfoService {
    private static final SettingBundle dataSources = ResourceLocator.getSettingBundle((String)"org.silverpeas.mydb.settings.dataSources");
    @Inject
    private MyDBConnectionInfoRepository repository;

    @Override
    public List<MyDBConnectionInfo> getConnectionInfoList(String instanceId) {
        return this.repository.findByInstanceId(instanceId);
    }

    @Override
    public void removeConnectionInfo(MyDBConnectionInfo connectionInfo) {
        this.repository.delete((IdentifiableEntity[])new MyDBConnectionInfo[]{connectionInfo});
    }

    @Override
    public void removeConnectionInfoOfComponentInstance(String componentInstanceId) {
        this.repository.deleteByInstanceId(componentInstanceId);
    }

    @Override
    public MyDBConnectionInfo getConnectionInfo(String id) {
        return (MyDBConnectionInfo)this.repository.getById(id);
    }

    @Override
    public MyDBConnectionInfo saveConnectionInfo(MyDBConnectionInfo connectionInfo) {
        return (MyDBConnectionInfo)this.repository.save((IdentifiableEntity)connectionInfo);
    }

    @Override
    public List<DataSourceDefinition> getAllDataSourceDefinitions() {
        int count = dataSources.getInteger("dataSource.count", 0);
        ArrayList<DataSourceDefinition> dataSourceDefinitions = new ArrayList<DataSourceDefinition>(count);
        for (int i = 0; i < count; ++i) {
            String jndiName = dataSources.getString("dataSource." + i + ".name");
            String description = dataSources.getString("dataSource." + i + ".description");
            if (StringUtil.isNotDefined((String)description)) {
                description = "";
            }
            dataSourceDefinitions.add(new DataSourceDefinition(jndiName, description));
        }
        return dataSourceDefinitions;
    }
}

