/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.record;

import org.silverpeas.components.whitepages.record.UserRecord;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.form.HtmlForm;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.logging.SilverLogger;

public class UserTemplate
implements RecordTemplate {
    private static final long serialVersionUID = -6724850073409580787L;
    private static final String SPECIFIC_DETAILS = "SpecificDetails";
    private final transient LocalizationBundle label;
    private transient HtmlForm viewForm;

    public UserTemplate(String fileName, String language) {
        this.label = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.whitePages.multilang.whitePagesBundle", (String)language);
        try {
            this.viewForm = new HtmlForm((RecordTemplate)this);
        }
        catch (FormException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        this.viewForm.setFileName(fileName);
    }

    public String[] getFieldNames() {
        String[] fieldNames = new String[]{"Id", "SpecificId", "DomainId", "Login", "FirstName", "LastName", "Mail", "AccessLevel", SPECIFIC_DETAILS};
        return fieldNames;
    }

    public FieldTemplate[] getFieldTemplates() {
        FieldTemplate[] fieldTemplates = new FieldTemplate[9];
        try {
            fieldTemplates[0] = this.getFieldTemplate("Id");
            fieldTemplates[1] = this.getFieldTemplate("SpecificId");
            fieldTemplates[2] = this.getFieldTemplate("DomainId");
            fieldTemplates[3] = this.getFieldTemplate("Login");
            fieldTemplates[4] = this.getFieldTemplate("FirstName");
            fieldTemplates[5] = this.getFieldTemplate("LastName");
            fieldTemplates[6] = this.getFieldTemplate("Mail");
            fieldTemplates[7] = this.getFieldTemplate("AccessLevel");
            fieldTemplates[8] = this.getFieldTemplate(SPECIFIC_DETAILS);
        }
        catch (FormException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return fieldTemplates;
    }

    public FieldTemplate getFieldTemplate(String fieldName) throws FormException {
        GenericFieldTemplate fieldTemplate = null;
        if (!fieldName.equals(SPECIFIC_DETAILS)) {
            fieldTemplate = new GenericFieldTemplate(fieldName, "text");
            fieldTemplate.setLabel(this.label.getString(fieldName));
            fieldTemplate.setDisplayerName("simpletext");
            fieldTemplate.setReadOnly(true);
        }
        return fieldTemplate;
    }

    public int getFieldIndex(String fieldName) throws FormException {
        return -1;
    }

    public DataRecord getEmptyRecord() throws FormException {
        return null;
    }

    public boolean checkDataRecord(DataRecord record) {
        return true;
    }

    public Form getViewForm() {
        return this.viewForm;
    }

    public UserRecord getRecord(String idUser) {
        UserFull userDetail = UserFull.getById((String)idUser);
        return new UserRecord((UserDetail)userDetail);
    }
}

