/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.forums.ForumsContentManager;
import org.silverpeas.components.forums.model.Forum;
import org.silverpeas.components.forums.model.ForumDetail;
import org.silverpeas.components.forums.model.ForumPK;
import org.silverpeas.components.forums.model.ForumPath;
import org.silverpeas.components.forums.model.Message;
import org.silverpeas.components.forums.model.MessagePK;
import org.silverpeas.components.forums.model.MessagePath;
import org.silverpeas.components.forums.model.Moderator;
import org.silverpeas.components.forums.service.ForumService;
import org.silverpeas.components.forums.service.ForumsDAO;
import org.silverpeas.components.forums.service.ForumsRuntimeException;
import org.silverpeas.components.forums.subscription.ForumMessageSubscription;
import org.silverpeas.components.forums.subscription.ForumMessageSubscriptionResource;
import org.silverpeas.components.forums.subscription.ForumSubscription;
import org.silverpeas.components.forums.subscription.ForumSubscriptionResource;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.rating.model.ContributionRatingPK;
import org.silverpeas.core.contribution.rating.service.RatingService;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.subscription.SubscriberDirective;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionService;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.subscription.service.ComponentSubscriptionResource;
import org.silverpeas.core.subscription.service.ResourceSubscriptionProvider;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.tagcloud.dao.TagCloudPK;
import org.silverpeas.core.tagcloud.model.TagCloud;
import org.silverpeas.core.tagcloud.model.TagCloudUtil;
import org.silverpeas.core.tagcloud.service.TagCloudService;
import org.silverpeas.core.util.StringUtil;

@Service
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultForumService
implements ForumService {
    private static final String RESOURCE_TYPE = "Forum";
    @Inject
    private TagCloudService tagcloud;
    @Inject
    private RatingService notation;
    @Inject
    private NodeService node;
    @Inject
    private ForumsContentManager forumsContentManager;

    @Override
    public Collection<ForumDetail> getForums(Collection<ForumPK> forumPKs) {
        Collection<ForumDetail> collection;
        block8: {
            Connection con = this.openConnection();
            try {
                collection = ForumsDAO.selectByForumPKs(con, forumPKs);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Forum getForum(ForumPK forumPK) {
        Forum forum;
        block8: {
            Connection con = this.openConnection();
            try {
                forum = ForumsDAO.getForum(con, forumPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return forum;
    }

    @Override
    public ForumPath getForumPath(ForumPK forumPK) {
        ForumPath forumPath;
        block10: {
            ArrayList<Forum> path = new ArrayList<Forum>();
            Connection con = this.openConnection();
            try {
                Forum currentForum = ForumsDAO.getForum(con, forumPK);
                if (currentForum != null) {
                    path.add(currentForum);
                    while (currentForum != null && !currentForum.isRoot()) {
                        currentForum = ForumsDAO.getForum(con, new ForumPK(forumPK.getInstanceId(), currentForum.getParentIdAsString()));
                        if (currentForum == null) continue;
                        path.add(currentForum);
                    }
                }
                forumPath = new ForumPath(path);
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return forumPath;
    }

    @Override
    public Collection<Forum> getForumRootList(String instanceId) {
        List<String> forumRootIds = this.getForumSonsIds(new ForumPK(instanceId, "0"));
        ArrayList<Forum> forumRoots = new ArrayList<Forum>();
        for (String forumRootId : forumRootIds) {
            forumRoots.add(this.getForum(new ForumPK(instanceId, forumRootId)));
        }
        return forumRoots;
    }

    @Override
    public Collection<Forum> getForumsList(Collection<ForumPK> forumPKs) {
        Collection<Forum> collection;
        block8: {
            Connection con = this.openConnection();
            try {
                collection = ForumsDAO.getForumsByKeys(con, forumPKs);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<Message> getThreadsList(Collection<MessagePK> messagePKs) {
        Collection<Message> collection;
        block8: {
            Connection con = this.openConnection();
            try {
                collection = ForumsDAO.getThreadsByKeys(con, messagePKs);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public String getForumName(int forumId) {
        String string;
        block8: {
            Connection con = this.openConnection();
            try {
                string = ForumsDAO.getForumName(con, forumId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return string;
    }

    @Override
    public void deleteAll(String instanceId) {
        try (Connection con = this.openConnection();){
            ForumsDAO.deleteAllForums(con, instanceId);
        }
        catch (SQLException e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    public boolean isForumActive(int forumId) {
        boolean bl;
        block8: {
            Connection con = this.openConnection();
            try {
                bl = ForumsDAO.isForumActive(con, forumId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return bl;
    }

    @Override
    public int getForumParentId(int forumId) {
        int n;
        block8: {
            Connection con = this.openConnection();
            try {
                n = ForumsDAO.getForumParentId(con, forumId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    public String getForumInstanceId(int forumId) {
        String string;
        block8: {
            Connection con = this.openConnection();
            try {
                string = ForumsDAO.getForumInstanceId(con, forumId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return string;
    }

    public String getForumCreatorId(int forumId) {
        String string;
        block8: {
            Connection con = this.openConnection();
            try {
                string = ForumsDAO.getForumCreatorId(con, forumId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return string;
    }

    @Override
    public List<Forum> getForums(ForumPK forumPK) {
        List<Forum> list;
        block8: {
            Connection con = this.openConnection();
            try {
                list = ForumsDAO.getForumsList(con, forumPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public ForumDetail getForumDetail(ForumPK forumPK) {
        ForumDetail forumDetail;
        block8: {
            Connection con = this.openConnection();
            try {
                forumDetail = ForumsDAO.getForumDetail(con, forumPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return forumDetail;
    }

    @Override
    public List<Forum> getForumsByCategory(ForumPK forumPK, String categoryId) {
        List<Forum> list;
        block8: {
            Connection con = this.openConnection();
            try {
                list = ForumsDAO.getForumsListByCategory(con, forumPK, categoryId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public List<String> getForumSonsIds(ForumPK forumPK) {
        List<String> list;
        block8: {
            Connection con = this.openConnection();
            try {
                list = ForumsDAO.getForumSonsIds(con, forumPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public void lockForum(ForumPK forumPK, int level) {
        List<String> sonsIds = this.getForumSonsIds(forumPK);
        for (String sonsId : sonsIds) {
            this.lockForum(new ForumPK(forumPK.getComponentName(), sonsId), level);
        }
        try (Connection con = this.openConnection();){
            ForumsDAO.lockForum(con, forumPK, level);
        }
        catch (SQLException e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    public int unlockForum(ForumPK forumPK, int level) {
        int n;
        block9: {
            List<String> sonsIds = this.getForumSonsIds(forumPK);
            for (String sonsId : sonsIds) {
                this.unlockForum(new ForumPK(forumPK.getComponentName(), sonsId), level);
            }
            Connection con = this.openConnection();
            try {
                n = ForumsDAO.unlockForum(con, forumPK, level);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteForum(ForumPK forumPK) {
        List<String> sonsIds = this.getForumSonsIds(forumPK);
        for (String sonsId : sonsIds) {
            this.deleteForum(new ForumPK(forumPK.getComponentName(), sonsId));
        }
        try (Connection con = this.openConnection();){
            this.getSubscribeService().unsubscribeByResource((SubscriptionResource)ForumSubscriptionResource.from(forumPK));
            List<String> messagesIds = this.getMessagesIds(forumPK);
            ForumsDAO.deleteForum(con, forumPK);
            this.deleteIndex(forumPK);
            for (String messagesId : messagesIds) {
                this.deleteMessage(new MessagePK(forumPK.getComponentName(), messagesId));
            }
            this.forumsContentManager.deleteSilverContent(con, forumPK);
            this.deleteTagCloud(forumPK);
            this.deleteNotation(forumPK);
        }
        catch (SQLException | ContentManagerException e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public int createForum(ForumPK forumPK, String forumName, String forumDescription, String forumCreator, int forumParent, String categoryId, String keywords) {
        int n;
        block8: {
            Connection con = this.openConnection();
            try {
                int forumId = ForumsDAO.createForum(con, forumPK, forumName, forumDescription, forumCreator, forumParent, categoryId);
                forumPK.setId(String.valueOf(forumId));
                this.createIndex(forumPK);
                this.forumsContentManager.createSilverContent(con, forumPK, forumCreator);
                this.createTagCloud(forumPK, keywords);
                n = forumId;
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException | ContentManagerException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    public void updateForum(ForumPK forumPK, String forumName, String forumDescription, int forumParent, String categoryId, String keywords) {
        this.updateForum(forumPK, forumName, forumDescription, forumParent, categoryId, keywords, true);
    }

    private void updateForum(ForumPK forumPK, String forumName, String forumDescription, int forumParent, String categoryId, String keywords, boolean updateTagCloud) {
        try (Connection con = this.openConnection();){
            ForumsDAO.updateForum(con, forumPK, forumName, forumDescription, forumParent, categoryId);
            this.deleteIndex(forumPK);
            this.createIndex(forumPK);
            if (updateTagCloud) {
                this.updateTagCloud(forumPK, keywords);
            }
        }
        catch (SQLException e) {
            throw new ForumsRuntimeException(e);
        }
    }

    private List<Message> getMessagesList(ForumPK forumPK) {
        List<Message> list;
        block8: {
            Connection con = this.openConnection();
            try {
                list = ForumsDAO.getMessagesList(con, forumPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public Collection<Message> getMessages(ForumPK forumPK) {
        List<Message> messages = this.getMessagesList(forumPK);
        String componentId = forumPK.getInstanceId();
        for (Message message : messages) {
            message.setText(this.getWysiwygContent(componentId, String.valueOf(message.getId())));
        }
        return messages;
    }

    private List<String> getSubjectsIds(ForumPK forumPK) {
        List<String> list;
        block8: {
            Connection con = this.openConnection();
            try {
                list = ForumsDAO.getSubjectsIds(con, forumPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    private List<String> getMessagesIds(ForumPK forumPK, int messageParentId) {
        List<String> list;
        block8: {
            Connection con = this.openConnection();
            try {
                list = ForumsDAO.getMessagesIds(con, forumPK, messageParentId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    private List<String> getMessagesIds(ForumPK forumPK) {
        return this.getMessagesIds(forumPK, -1);
    }

    @Override
    public int getNbMessages(int forumId, String type, String status) {
        int n;
        block8: {
            Connection con = this.openConnection();
            try {
                n = ForumsDAO.getNbMessages(con, forumId, type, status);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    public int getAuthorNbMessages(String userId, String status) {
        int n;
        block8: {
            Connection con = this.openConnection();
            try {
                n = ForumsDAO.getAuthorNbMessages(con, userId, status);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    public int getNbResponses(int forumId, int messageId, String status) {
        int n;
        block8: {
            Connection con = this.openConnection();
            try {
                n = ForumsDAO.getNbResponses(con, forumId, messageId, status);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    public Message getLastMessage(ForumPK forumPK, String status) {
        Message message;
        block8: {
            Connection con = this.openConnection();
            try {
                message = ForumsDAO.getLastMessage(con, forumPK, status);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return message;
    }

    @Override
    public Collection getLastMessageRSS(String instanceId, int nbReturned) {
        ArrayList<List> messages = new ArrayList<List>();
        try (Connection con = this.openConnection();){
            Collection<String> allMessagesIds = ForumsDAO.getLastMessageRSS(con, instanceId);
            Iterator<String> it = allMessagesIds.iterator();
            for (int countdown = nbReturned; it.hasNext() && countdown != 0; --countdown) {
                String messageId = it.next();
                MessagePK messagePK = new MessagePK(instanceId, messageId);
                messages.add(this.getMessageInfos(messagePK));
            }
        }
        catch (SQLException e) {
            throw new ForumsRuntimeException(e);
        }
        return messages;
    }

    @Override
    public Message getLastMessage(ForumPK forumPK, int messageParentId, String status) {
        try {
            List<String> messagesIds = this.getMessagesIds(forumPK, messageParentId);
            messagesIds.add(String.valueOf(messageParentId));
            return this.getLastMessage(forumPK, messagesIds, status);
        }
        catch (Exception e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    public Message getLastMessage(ForumPK forumPK, List<String> messageParentIds, String status) {
        Message message;
        block8: {
            Connection con = this.openConnection();
            try {
                message = ForumsDAO.getLastMessage(con, forumPK, messageParentIds, status);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return message;
    }

    @Override
    public boolean isNewMessageByForum(String userId, ForumPK forumPK, String status) {
        List<String> messagesIds = this.getSubjectsIds(forumPK);
        for (String messagesId : messagesIds) {
            int messageParentId = Integer.parseInt(messagesId);
            if (!this.isNewMessage(userId, forumPK, messageParentId, status)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isNewMessage(String userId, ForumPK forumPK, int messageParentId, String status) {
        try (Connection con = this.openConnection();){
            List<String> messagesIds = this.getMessagesIds(forumPK, messageParentId);
            messagesIds.add(String.valueOf(messageParentId));
            Message message = this.getLastMessage(forumPK, messagesIds, status);
            Date dateLastMessageBySubject = message != null ? message.getDate() : null;
            Date dateLastVisit = ForumsDAO.getLastVisit(con, userId, messagesIds);
            if (dateLastMessageBySubject != null && dateLastVisit != null) {
                if (!dateLastVisit.before(dateLastMessageBySubject)) return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    public void setLastVisit(String userId, int messageId) {
        try (Connection con = this.openConnection();){
            ForumsDAO.addLastVisit(con, userId, messageId);
        }
        catch (Exception e) {
            throw new ForumsRuntimeException(e);
        }
    }

    private List getMessageInfos(MessagePK messagePK) {
        List list;
        block8: {
            Connection con = this.openConnection();
            try {
                list = ForumsDAO.getMessageInfos(con, messagePK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public Message getMessage(MessagePK messagePK) {
        Message message;
        block9: {
            Connection con = this.openConnection();
            try {
                Message message2 = ForumsDAO.getMessage(con, messagePK);
                if (message2 != null) {
                    message2.setText(this.getWysiwygContent(messagePK.getInstanceId(), messagePK.getId()));
                }
                message = message2;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return message;
    }

    @Override
    public MessagePath getMessagePath(MessagePK messagePK) {
        ArrayList<Message> path = new ArrayList<Message>();
        Message currentMessage = this.getMessage(messagePK);
        if (currentMessage != null) {
            path.add(currentMessage);
            while (currentMessage != null && !currentMessage.isSubject()) {
                currentMessage = this.getMessage(new MessagePK(messagePK.getInstanceId(), currentMessage.getParentIdAsString()));
                if (currentMessage == null) continue;
                path.add(currentMessage);
            }
        }
        Message subject = (Message)path.iterator().next();
        return new MessagePath(this.getForumPath(new ForumPK(subject.getInstanceId(), subject.getForumIdAsString())), path);
    }

    @Override
    public String getMessageTitle(int messageId) {
        String string;
        block8: {
            Connection con = this.openConnection();
            try {
                string = ForumsDAO.getMessageTitle(con, messageId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return string;
    }

    @Override
    public int getMessageParentId(int messageId) {
        int n;
        block8: {
            Connection con = this.openConnection();
            try {
                n = ForumsDAO.getMessageParentId(con, messageId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public int createMessage(MessagePK messagePK, String title, String authorId, Date creationDate, int forumId, int parentId, String content, String keywords, String status) {
        int n;
        block8: {
            Connection con = this.openConnection();
            try {
                int messageId = ForumsDAO.createMessage(con, title, authorId, creationDate, forumId, parentId, status);
                messagePK.setId(String.valueOf(messageId));
                this.createTagCloud(messagePK, keywords);
                this.createWysiwyg(messagePK, content, authorId);
                this.createIndex(messagePK);
                n = messageId;
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void updateMessage(MessagePK messagePK, String title, String message, String userId, String status) {
        try (Connection con = this.openConnection();){
            this.deleteIndex(messagePK);
            ForumsDAO.updateMessage(con, messagePK, title, status);
            this.updateWysiwyg(messagePK, message, userId);
            this.createIndex(messagePK);
        }
        catch (SQLException e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    public void updateMessageKeywords(MessagePK messagePK, String keywords) {
        try {
            this.updateTagCloud(messagePK, keywords);
        }
        catch (Exception e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteMessage(MessagePK messagePK) {
        try (Connection con = this.openConnection();){
            Collection<String> messageChildren = ForumsDAO.getMessageSons(con, messagePK);
            if (!messageChildren.isEmpty()) {
                for (String child : messageChildren) {
                    this.deleteMessage(new MessagePK(messagePK.getComponentName(), child));
                }
            }
            this.getSubscribeService().unsubscribeByResource((SubscriptionResource)ForumMessageSubscriptionResource.from(messagePK));
            ForumsDAO.deleteMessage(con, messagePK);
            this.deleteIndex(messagePK);
            this.deleteTagCloud(messagePK);
            this.deleteNotation(messagePK);
            this.deleteAllAttachments(messagePK);
        }
        catch (SQLException e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    public boolean isModerator(String userId, ForumPK forumPK) {
        if (!"0".equals(forumPK.getId())) {
            boolean bl;
            block9: {
                Connection con = this.openConnection();
                try {
                    bl = ForumsDAO.isModerator(con, forumPK, userId);
                    if (con == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new ForumsRuntimeException(e);
                    }
                }
                con.close();
            }
            return bl;
        }
        return false;
    }

    @Override
    public void addModerator(ForumPK forumPK, String userId) {
        try (Connection con = this.openConnection();){
            ForumsDAO.addModerator(con, forumPK, userId);
        }
        catch (SQLException e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    public void removeModerator(ForumPK forumPK, String userId) {
        try (Connection con = this.openConnection();){
            ForumsDAO.removeModerator(con, forumPK, userId);
        }
        catch (Exception e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    public void removeAllModerators(ForumPK forumPK) {
        try (Connection con = this.openConnection();){
            ForumsDAO.removeAllModerators(con, forumPK);
        }
        catch (SQLException e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    public List<Moderator> getModerators(int forumId) {
        List<Moderator> list;
        block10: {
            Connection con = this.openConnection();
            try {
                List<Moderator> moderators = ForumsDAO.getModerators(con, forumId);
                int parentId = this.getForumParentId(forumId);
                while (parentId > 0) {
                    for (Moderator moderatorByInheritance : ForumsDAO.getModerators(con, parentId)) {
                        moderatorByInheritance.setByInheritance(true);
                        moderators.add(moderatorByInheritance);
                    }
                    parentId = this.getForumParentId(parentId);
                }
                list = moderators;
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void moveMessage(MessagePK messagePK, ForumPK forumPK) {
        try (Connection con = this.openConnection();){
            Collection<String> children = ForumsDAO.getMessageSons(con, messagePK);
            if (!children.isEmpty()) {
                for (String childId : children) {
                    this.moveMessage(new MessagePK(messagePK.getComponentName(), childId), forumPK);
                }
            }
            ForumsDAO.moveMessage(con, messagePK, forumPK);
        }
        catch (SQLException e) {
            throw new ForumsRuntimeException(e);
        }
    }

    public Collection<String> getMessageSons(MessagePK messagePK) {
        Collection<String> collection;
        block8: {
            Connection con = this.openConnection();
            try {
                collection = ForumsDAO.getMessageSons(con, messagePK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    public Collection<String> getAllMessageSons(MessagePK messagePK) {
        Collection<String> collection;
        block8: {
            Connection con = this.openConnection();
            try {
                collection = ForumsDAO.getAllMessageSons(con, messagePK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ForumsRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void subscribeMessage(MessagePK messagePK, String userId) {
        this.getSubscribeService().subscribe((Subscription)new ForumMessageSubscription(userId, messagePK));
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void unsubscribeMessage(MessagePK messagePK, String userId) {
        this.getSubscribeService().unsubscribe((Subscription)new ForumMessageSubscription(userId, messagePK));
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void subscribeForum(ForumPK forumPK, String userId) {
        this.getSubscribeService().subscribe((Subscription)new ForumSubscription(userId, forumPK));
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void unsubscribeForum(ForumPK forumPK, String userId) {
        this.getSubscribeService().unsubscribe((Subscription)new ForumSubscription(userId, forumPK));
    }

    @Override
    public SubscriptionSubscriberList listAllSubscribers(MessagePK messagePK) {
        return ResourceSubscriptionProvider.getSubscribersOfSubscriptionResource((SubscriptionResource)ForumMessageSubscriptionResource.from(messagePK), (SubscriberDirective[])new SubscriberDirective[0]);
    }

    @Override
    public SubscriptionSubscriberList listAllSubscribers(ForumPK forumPK) {
        return ResourceSubscriptionProvider.getSubscribersOfSubscriptionResource((SubscriptionResource)ForumSubscriptionResource.from(forumPK), (SubscriberDirective[])new SubscriberDirective[0]);
    }

    @Override
    public SubscriptionSubscriberList listAllSubscribers(String instanceId) {
        return ResourceSubscriptionProvider.getSubscribersOfComponent((String)instanceId);
    }

    @Override
    public boolean isSubscriber(MessagePK messagePK, String userId) {
        return this.getSubscribeService().isUserSubscribedToResource(userId, (SubscriptionResource)ForumMessageSubscriptionResource.from(messagePK));
    }

    @Override
    public boolean isSubscriberByInheritance(MessagePK messagePK, String userId) {
        return !this.isSubscriber(messagePK, userId) && ResourceSubscriptionProvider.getSubscribersOfSubscriptionResource((SubscriptionResource)ForumMessageSubscriptionResource.from(messagePK), (SubscriberDirective[])new SubscriberDirective[0]).getAllUserIds().contains(userId);
    }

    @Override
    public boolean isSubscriber(ForumPK forumPK, String userId) {
        return this.getSubscribeService().isUserSubscribedToResource(userId, (SubscriptionResource)ForumSubscriptionResource.from(forumPK));
    }

    @Override
    public boolean isSubscriberByInheritance(ForumPK forumPK, String userId) {
        return !this.isSubscriber(forumPK, userId) && ResourceSubscriptionProvider.getSubscribersOfSubscriptionResource((SubscriptionResource)ForumSubscriptionResource.from(forumPK), (SubscriberDirective[])new SubscriberDirective[0]).getAllUserIds().contains(userId);
    }

    @Override
    public boolean isSubscriber(String instanceId, String userId) {
        return this.getSubscribeService().isUserSubscribedToResource(userId, (SubscriptionResource)ComponentSubscriptionResource.from((String)instanceId));
    }

    @Override
    public void createIndex(MessagePK messagePK) {
        if (messagePK != null) {
            Message message = this.getMessage(messagePK);
            String componentId = messagePK.getComponentName();
            String messageId = messagePK.getId();
            FullIndexEntry indexEntry = new FullIndexEntry(componentId, "Message", messageId);
            indexEntry.setTitle(message.getTitle());
            indexEntry.setCreationDate(message.getDate());
            indexEntry.setCreationUser(message.getAuthor());
            WysiwygController.addToIndex((FullIndexEntry)indexEntry, (ResourceReference)new ResourceReference((WAPrimaryKey)messagePK), (String)I18NHelper.DEFAULT_LANGUAGE);
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
    }

    private void deleteIndex(MessagePK messagePK) {
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)new IndexEntryKey(messagePK.getComponentName(), "Message", messagePK.getId()));
    }

    @Override
    public void createIndex(ForumPK forumPK) {
        if (forumPK != null) {
            Forum forum = this.getForum(forumPK);
            FullIndexEntry indexEntry = new FullIndexEntry(forumPK.getComponentName(), RESOURCE_TYPE, forumPK.getId());
            indexEntry.setTitle(forum.getName());
            indexEntry.setPreview(forum.getDescription());
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
    }

    private void deleteIndex(ForumPK forumPK) {
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)new IndexEntryKey(forumPK.getComponentName(), RESOURCE_TYPE, forumPK.getId()));
    }

    protected Connection openConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (SQLException ue) {
            throw new ForumsRuntimeException(ue);
        }
    }

    @Override
    public int getSilverObjectId(ForumPK forumPK) {
        int silverObjectId = -1;
        try {
            int forumId = Integer.parseInt(forumPK.getId());
            String instanceId = forumPK.getComponentName();
            if (instanceId == null || instanceId.length() == 0) {
                instanceId = this.getForumInstanceId(forumId);
                forumPK.setComponentName(instanceId);
            }
            if ((silverObjectId = this.forumsContentManager.getSilverContentId(forumPK.getId(), instanceId)) == -1) {
                String creatorId = this.getForumCreatorId(forumId);
                silverObjectId = this.forumsContentManager.createSilverContent(null, forumPK, creatorId);
            }
        }
        catch (Exception e) {
            throw new ForumsRuntimeException(e);
        }
        return silverObjectId;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public String createCategory(NodeDetail category) {
        try {
            NodePK nodePK = this.node.createNode(category, new NodeDetail());
            return nodePK.getId();
        }
        catch (Exception e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void updateCategory(NodeDetail category) {
        this.node.setDetail(category);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteCategory(String categoryId, String instanceId) {
        try {
            List<Forum> forums = this.getForumsByCategory(new ForumPK(instanceId, null), categoryId);
            for (Forum forum : forums) {
                ForumPK forumPK = new ForumPK(instanceId, forum.getIdAsString());
                this.updateForum(forumPK, forum.getName(), forum.getDescription(), forum.getParentId(), null, null, false);
            }
            NodePK nodePk = new NodePK(categoryId, instanceId);
            this.node.removeNode(nodePk);
        }
        catch (Exception e) {
            throw new ForumsRuntimeException(e);
        }
    }

    @Override
    public NodeDetail getCategory(NodePK pk) {
        return this.node.getDetail(pk);
    }

    @Override
    public Collection<NodeDetail> getAllCategories(String instanceId) {
        return this.node.getChildrenDetails(new NodePK("0", instanceId));
    }

    @Override
    public Collection<Message> getLastThreads(ForumPK forumPK, int count) {
        return this.getLastThreads(forumPK, count, false);
    }

    @Override
    public Collection<Message> getNotAnsweredLastThreads(ForumPK forumPK, int count) {
        return this.getLastThreads(forumPK, count, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Message> getLastThreads(ForumPK forumPK, int count, boolean notAnswered) {
        try (Connection con = this.openConnection();){
            Collection<Message> collection;
            ForumPK[] forumPKs;
            if ("0".equals(forumPK.getId())) {
                List<String> forumsIds = ForumsDAO.getForumsIds(con, forumPK);
                int forumsCount = forumsIds.size();
                forumPKs = new ForumPK[forumsCount];
                String componentId = forumPK.getComponentName();
                for (int i = 0; i < forumsCount; ++i) {
                    forumPKs[i] = new ForumPK(componentId, forumsIds.get(i));
                }
            } else {
                forumPKs = new ForumPK[]{forumPK};
            }
            if (notAnswered) {
                collection = ForumsDAO.getNotAnsweredLastThreads(con, forumPKs, count);
                return collection;
            }
            collection = ForumsDAO.getLastThreads(con, forumPKs, count);
            return collection;
        }
        catch (Exception e) {
            throw new ForumsRuntimeException(e);
        }
    }

    private void createTagCloud(ForumPK forumPK, String keywords) {
        TagCloud tagCloud = new TagCloud(forumPK.getComponentName(), forumPK.getId(), 1);
        this.createTagCloud(tagCloud, keywords);
    }

    private void createTagCloud(MessagePK messagePK, String keywords) {
        TagCloud tagCloud = new TagCloud(messagePK.getComponentName(), messagePK.getId(), 2);
        this.createTagCloud(tagCloud, keywords);
    }

    private void createTagCloud(TagCloud tags, String keywords) {
        if (keywords != null) {
            String[] words = StringUtil.split((String)keywords, (char)' ');
            ArrayList<String> tagList = new ArrayList<String>(words.length);
            for (String tag : words) {
                String tagKey = TagCloudUtil.getTag((String)tag);
                if (tagList.contains(tagKey)) continue;
                tags.setTag(tagKey);
                tags.setLabel(tag.toLowerCase());
                this.tagcloud.createTagCloud(tags);
                tagList.add(tagKey);
            }
        }
    }

    private void deleteTagCloud(ForumPK forumPK) {
        this.tagcloud.deleteTagCloud(new TagCloudPK(forumPK.getId(), forumPK.getComponentName()), 1);
    }

    private void deleteTagCloud(MessagePK messagePK) {
        this.tagcloud.deleteTagCloud(new TagCloudPK(messagePK.getId(), messagePK.getComponentName()), 2);
    }

    private void updateTagCloud(ForumPK forumPK, String keywords) {
        this.deleteTagCloud(forumPK);
        this.createTagCloud(forumPK, keywords);
    }

    private void updateTagCloud(MessagePK messagePK, String keywords) {
        this.deleteTagCloud(messagePK);
        this.createTagCloud(messagePK, keywords);
    }

    @Override
    public String getForumTags(ForumPK forumPK) {
        Collection tagClouds = this.tagcloud.getTagCloudsByElement(forumPK.getComponentName(), forumPK.getId(), 1);
        return this.getTags(tagClouds);
    }

    @Override
    public String getMessageTags(MessagePK messagePK) {
        Collection tagClouds = this.tagcloud.getTagCloudsByElement(messagePK.getComponentName(), messagePK.getId(), 2);
        return this.getTags(tagClouds);
    }

    private String getTags(Collection<TagCloud> tagClouds) {
        StringBuilder sb = new StringBuilder();
        for (TagCloud tag : tagClouds) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(tag.getLabel());
        }
        return sb.toString();
    }

    private void deleteNotation(ForumPK forumPK) {
        this.notation.deleteRating(new ContributionRatingPK(forumPK.getId(), forumPK.getComponentName(), RESOURCE_TYPE));
    }

    private void deleteNotation(MessagePK messagePK) {
        this.notation.deleteRating(new ContributionRatingPK(messagePK.getId(), messagePK.getComponentName(), "ForumMessage"));
    }

    protected String getWysiwygContent(String componentId, String messageId) {
        String text = "";
        if (WysiwygController.haveGotWysiwyg((String)componentId, (String)messageId, (String)I18NHelper.DEFAULT_LANGUAGE)) {
            text = WysiwygController.load((String)componentId, (String)messageId, (String)I18NHelper.DEFAULT_LANGUAGE);
        }
        return text;
    }

    private void createWysiwyg(MessagePK messagePK, String text, String userId) {
        WysiwygController.createUnindexedFileAndAttachment((String)text, (ResourceReference)new ResourceReference((WAPrimaryKey)messagePK), (String)userId, (String)I18NHelper.DEFAULT_LANGUAGE);
    }

    private void updateWysiwyg(MessagePK messagePK, String text, String userId) {
        String messageId;
        String componentId = messagePK.getComponentName();
        if (WysiwygController.haveGotWysiwyg((String)componentId, (String)(messageId = messagePK.getId()), (String)I18NHelper.DEFAULT_LANGUAGE)) {
            WysiwygController.updateFileAndAttachment((String)text, (String)componentId, (String)messageId, (String)userId, (String)I18NHelper.DEFAULT_LANGUAGE);
        } else {
            WysiwygController.createUnindexedFileAndAttachment((String)text, (ResourceReference)new ResourceReference((WAPrimaryKey)messagePK), (String)userId, (String)I18NHelper.DEFAULT_LANGUAGE);
        }
    }

    private void deleteAllAttachments(MessagePK messagePK) {
        ResourceReference foreignKey = new ResourceReference((WAPrimaryKey)messagePK);
        SimpleDocumentList documents = AttachmentServiceProvider.getAttachmentService().listAllDocumentsByForeignKey(foreignKey, null);
        for (SimpleDocument doc : documents) {
            AttachmentServiceProvider.getAttachmentService().deleteAttachment(doc);
        }
    }

    protected SubscriptionService getSubscribeService() {
        return SubscriptionServiceProvider.getSubscribeService();
    }
}

