/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ConfigurationEntityResolver;
import org.apache.jackrabbit.core.config.ConfigurationErrorHandler;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.util.Text;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigurationParser {
    public static final String PARAM_ELEMENT = "param";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String VALUE_ATTRIBUTE = "value";
    private final Properties variables;

    public ConfigurationParser(Properties variables) {
        this.variables = variables;
    }

    public Properties getVariables() {
        return this.variables;
    }

    protected BeanConfig parseBeanConfig(Element parent, String name) throws ConfigurationException {
        Element element = this.getElement(parent, name);
        return this.parseBeanConfig(element);
    }

    protected BeanConfig parseBeanConfig(Element element) throws ConfigurationException {
        String className = this.getAttribute(element, CLASS_ATTRIBUTE);
        Properties properties = this.parseParameters(element);
        return new BeanConfig(className, properties);
    }

    protected Properties parseParameters(Element element) throws ConfigurationException {
        Properties parameters = new Properties();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !PARAM_ELEMENT.equals(child.getNodeName())) continue;
            Element parameter = (Element)child;
            Attr name = parameter.getAttributeNode(NAME_ATTRIBUTE);
            if (name == null) {
                throw new ConfigurationException("Parameter name not set");
            }
            Attr value = parameter.getAttributeNode(VALUE_ATTRIBUTE);
            if (value == null) {
                throw new ConfigurationException("Parameter value not set");
            }
            parameters.put(name.getValue().trim(), this.replaceVariables(value.getValue()));
        }
        return parameters;
    }

    protected String replaceVariables(String value) throws ConfigurationException {
        try {
            return Text.replaceVariables((Properties)this.variables, (String)value, (boolean)false);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(e.getMessage(), (Exception)e);
        }
    }

    protected Element parseXML(InputSource xml) throws ConfigurationException {
        return this.parseXML(xml, false);
    }

    protected ErrorHandler getErrorHandler() {
        return new ConfigurationErrorHandler();
    }

    protected EntityResolver getEntityResolver() {
        return ConfigurationEntityResolver.INSTANCE;
    }

    protected Document postParseModificationHook(Document document) {
        return document;
    }

    protected Element parseXML(InputSource xml, boolean validate) throws ConfigurationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validate);
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (validate) {
                builder.setErrorHandler(this.getErrorHandler());
            }
            builder.setEntityResolver(this.getEntityResolver());
            Document document = builder.parse(xml);
            return this.postParseModificationHook(document).getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Unable to create configuration XML parser", (Exception)e);
        }
        catch (SAXParseException e) {
            throw new ConfigurationException("Configuration file syntax error. (Line: " + e.getLineNumber() + " Column: " + e.getColumnNumber() + ")", (Exception)e);
        }
        catch (SAXException e) {
            throw new ConfigurationException("Configuration file syntax error. ", (Exception)e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration file could not be read.", (Exception)e);
        }
    }

    protected Element getElement(Element parent, String name) throws ConfigurationException {
        return this.getElement(parent, name, true);
    }

    protected Element getElement(Element parent, String name, boolean required) throws ConfigurationException {
        NodeList children = parent.getChildNodes();
        Element found = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            if (found != null) {
                throw new ConfigurationException("Duplicate configuration element " + name + " in " + parent.getNodeName() + ".");
            }
            found = (Element)child;
        }
        if (required && found == null) {
            throw new ConfigurationException("Configuration element " + name + " not found in " + parent.getNodeName() + ".");
        }
        return found;
    }

    protected Element[] getElements(Element parent, String name, boolean required) throws ConfigurationException {
        NodeList children = parent.getChildNodes();
        ArrayList<Element> found = new ArrayList<Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            found.add((Element)child);
        }
        if (required && found.isEmpty()) {
            throw new ConfigurationException("Configuration element " + name + " not found in " + parent.getNodeName() + ".");
        }
        return found.toArray(new Element[found.size()]);
    }

    protected String getAttribute(Element element, String name) throws ConfigurationException {
        Attr attribute = element.getAttributeNode(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        throw new ConfigurationException("Configuration attribute " + name + " not found in " + element.getNodeName() + ".");
    }

    protected String getAttribute(Element element, String name, String def) {
        Attr attribute = element.getAttributeNode(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        return def;
    }
}

