/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.virtual;

import java.util.HashMap;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.virtual.AbstractVISProvider;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.core.virtual.VirtualPropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class VirtualNodeState
extends NodeState {
    protected final VirtualItemStateProvider stateMgr;
    private final HashMap<Name, VirtualPropertyState> properties = new HashMap();
    private HashSet<NodeState> stateRefs = null;

    public VirtualNodeState(AbstractVISProvider stateMgr, NodeId parentId, NodeId id, Name nodeTypeName, Name[] mixins) throws RepositoryException {
        super(id, nodeTypeName, parentId, 1, false);
        this.stateMgr = stateMgr;
        this.setContainer(stateMgr);
        this.setPropertyValue(NameConstants.JCR_PRIMARYTYPE, InternalValue.create(nodeTypeName));
        this.setMixinNodeTypes(mixins);
    }

    public VirtualPropertyState[] getProperties() {
        return this.properties.values().toArray(new VirtualPropertyState[this.properties.size()]);
    }

    public InternalValue[] getPropertyValues(Name name) throws NoSuchItemStateException {
        VirtualPropertyState ps = this.getProperty(name);
        if (ps == null) {
            return null;
        }
        return ps.getValues();
    }

    public InternalValue getPropertyValue(Name name) throws NoSuchItemStateException {
        VirtualPropertyState ps = this.getProperty(name);
        if (ps == null || ps.getValues().length == 0) {
            return null;
        }
        return ps.getValues()[0];
    }

    public VirtualPropertyState getProperty(Name name) throws NoSuchItemStateException {
        return this.properties.get(name);
    }

    public void setPropertyValue(Name name, InternalValue value) throws RepositoryException {
        this.setPropertyValues(name, value.getType(), new InternalValue[]{value}, false);
    }

    public void setPropertyValues(Name name, int type, InternalValue[] values) throws RepositoryException {
        this.setPropertyValues(name, type, values, true);
    }

    public void setPropertyValues(Name name, int type, InternalValue[] values, boolean multiple) throws RepositoryException {
        VirtualPropertyState prop = this.getOrCreatePropertyState(name, type, multiple);
        prop.setValues(values);
    }

    protected VirtualPropertyState getOrCreatePropertyState(Name name, int type, boolean multiValued) throws RepositoryException {
        VirtualPropertyState prop = this.properties.get(name);
        if (prop == null) {
            prop = this.stateMgr.createPropertyState(this, name, type, multiValued);
            this.properties.put(name, prop);
            this.addPropertyName(name);
        }
        return prop;
    }

    public void setMixinNodeTypes(Name[] mixins) throws RepositoryException {
        if (mixins != null) {
            HashSet<Name> set = new HashSet<Name>();
            InternalValue[] values = new InternalValue[mixins.length];
            for (int i = 0; i < mixins.length; ++i) {
                set.add(mixins[i]);
                values[i] = InternalValue.create(mixins[i]);
            }
            this.setMixinTypeNames(set);
            this.setPropertyValues(NameConstants.JCR_MIXINTYPES, 7, values);
        }
    }

    public void addStateReference(NodeState state) {
        if (this.stateRefs == null) {
            this.stateRefs = new HashSet();
        }
        this.stateRefs.add(state);
    }
}

