/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager.service;

import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.resourcesmanager.model.ReservedResource;
import org.silverpeas.components.resourcesmanager.model.ReservedResourcePk;
import org.silverpeas.components.resourcesmanager.repository.ReservedResourceRepository;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;

@Service
@Transactional
public class ReservedResourceService {
    @Inject
    ReservedResourceRepository repository;

    public void create(ReservedResource resource) {
        this.repository.saveAndFlush((IdentifiableEntity)resource);
    }

    public ReservedResource getReservedResource(long resourceId, long reservationId) {
        return (ReservedResource)this.repository.getById(new ReservedResourcePk(resourceId, reservationId).asString());
    }

    public void update(ReservedResource resource) {
        this.repository.saveAndFlush((IdentifiableEntity)resource);
    }

    public void delete(ReservedResource reservedResource) {
        this.repository.delete((IdentifiableEntity[])new ReservedResource[]{reservedResource});
    }

    public List<ReservedResource> findAllReservedResourcesWithProblem(long currentReservationId, List<Long> futureReservedResourceIds, String startPeriod, String endPeriod) {
        return this.repository.findAllReservedResourcesWithProblem(currentReservationId, futureReservedResourceIds, startPeriod, endPeriod);
    }

    public List<ReservedResource> findAllReservedResourcesOfReservation(long currentReservationId) {
        return this.repository.findAllReservedResourcesOfReservation(currentReservationId);
    }
}

