/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception. You should have recieved a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package org.silverpeas.processmanager;

import org.silverpeas.core.exception.SilverpeasException;

/**
 * Thrown by the processManager components.
 */
public class ProcessManagerException extends SilverpeasException {

  private static final long serialVersionUID = 4403838459103863944L;

  /**
   * Returns the module name.
   */
  @Override
  public String getModule() {
    return "processManager";
  }

  /**
   * Set the caller and the error message
   */
  public ProcessManagerException(String caller, String message) {
    super(caller, SilverpeasException.ERROR, message);
  }

  /**
   * Set the caller, the error message and the nested exception.
   */
  public ProcessManagerException(String caller, String message,
      Exception nestedException) {
    super(caller, SilverpeasException.ERROR, message, nestedException);
  }

  /**
   * Set the caller, infos and the error message
   */
  public ProcessManagerException(String caller, String message, String infos) {
    super(caller, SilverpeasException.ERROR, message, infos);
  }

  /**
   * Set the caller, the error message, infos and the nested exception.
   */
  public ProcessManagerException(String caller, String message, String infos,
      Exception nestedException) {
    super(caller, SilverpeasException.ERROR, message, infos, nestedException);
  }

  /**
   * Set the caller, the level and the error message. Used only by the FatalProcessManagerException
   */
  protected ProcessManagerException(String caller, int level, String message) {
    super(caller, level, message);
  }

  /**
   * Set the caller, the level, the error message and the nested exception. Used only by the
   * FatalProcessManagerException
   */
  protected ProcessManagerException(String caller, int level, String message,
      Exception nestedException) {
    super(caller, level, message, nestedException);
  }

  /**
   * Set the caller, the level, the error message and infos. Used only by the
   * FatalProcessManagerException
   */
  protected ProcessManagerException(String caller, int level, String message,
      String infos) {
    super(caller, level, message, infos);
  }

  /**
   * Set the caller, the level, the error message, infos and the nested exception. Used only by the
   * FatalProcessManagerException
   */
  protected ProcessManagerException(String caller, int level, String message,
      String infos, Exception nestedException) {
    super(caller, level, message, infos, nestedException);
  }
}
