/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mydb.model.predicates;

import org.silverpeas.components.mydb.model.DbColumn;
import org.silverpeas.components.mydb.model.predicates.ColumnValuePredicate;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;

public abstract class AbstractColumnValuePredicate
implements ColumnValuePredicate {
    public static final String NULL_VALUE = "null";
    public static final String EMPTY_VALUE = "@empty@";
    private DbColumn column;
    private String value;
    private Object normalizedValue;

    public AbstractColumnValuePredicate(DbColumn column, String refValue) {
        this.column = column;
        this.value = refValue;
        this.normalizedValue = AbstractColumnValuePredicate.normalizeValue(column, refValue);
    }

    AbstractColumnValuePredicate() {
    }

    private static Object normalizeValue(DbColumn column, String value) {
        Object normalizedValue = NULL_VALUE.equals(value) ? null : (EMPTY_VALUE.equals(value) ? "" : column.getJdbcValueOf(value));
        return normalizedValue;
    }

    Object getNormalizedValue() {
        return this.normalizedValue;
    }

    @Override
    public DbColumn getColumn() {
        return this.column;
    }

    @Override
    public Comparable getReferenceValue() {
        return this.value;
    }

    public abstract JdbcSqlQuery apply(JdbcSqlQuery var1);
}

