/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.constant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.file.FileUtil;

public enum MediaMimeType {
    BMP(new String[0]),
    GIF(new String[0]),
    PNG(new String[0]),
    JPG("jpeg", "pjpeg"),
    TIFF("tif"),
    MOV(new String[0]),
    MP4(new String[0]),
    FLV(new String[0]),
    MP3(new String[0]),
    ERROR(new String[0]);

    public static final Set<MediaMimeType> PHOTOS;
    public static final Set<MediaMimeType> VIDEOS;
    public static final Set<MediaMimeType> SOUNDS;
    private static final Set<MediaMimeType> ALL_VALIDS;
    private final String mimeType;
    private final List<String> extensions;

    private MediaMimeType(String ... otherExtensions) {
        String identifiedMimeType;
        try {
            identifiedMimeType = ("ERROR".equals(this.name()) ? "" : new MimeType(FileUtil.getMimeType((String)("file." + this.name().toLowerCase())))).toString();
        }
        catch (MimeTypeParseException e) {
            identifiedMimeType = "application/octet-stream";
        }
        this.mimeType = identifiedMimeType;
        this.extensions = new ArrayList<String>();
        this.extensions.add(this.name().toLowerCase());
        Collections.addAll(this.extensions, otherExtensions);
    }

    public static MediaMimeType fromFile(File file) {
        return MediaMimeType.fromMimeType(file != null ? FileUtil.getMimeType((String)file.getPath()) : "");
    }

    public static MediaMimeType fromMimeType(String mimeType) {
        if (StringUtil.isDefined((String)mimeType)) {
            if ("image/pjpeg".equals(mimeType)) {
                return JPG;
            }
            if ("video/m4v".equals(mimeType.replace("/x-", "/"))) {
                return MP4;
            }
            for (MediaMimeType mediaMimeType : ALL_VALIDS) {
                if (!mediaMimeType.mimeType.equals(mimeType) && !mediaMimeType.mimeType.equals(mimeType.replace("x-ms-", ""))) continue;
                return mediaMimeType;
            }
        }
        return ERROR;
    }

    public String getName() {
        return this.name();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public boolean isSupportedMediaType() {
        return ALL_VALIDS.contains((Object)this);
    }

    public boolean isSupportedPhotoType() {
        return PHOTOS.contains((Object)this);
    }

    public boolean isSupportedVideoType() {
        return VIDEOS.contains((Object)this);
    }

    public boolean isSupportedSoundType() {
        return SOUNDS.contains((Object)this);
    }

    public boolean isReadablePhoto() {
        return this == GIF || this == JPG || this == PNG || this == BMP;
    }

    public boolean isPreviewablePhoto() {
        return this.isReadablePhoto();
    }

    public boolean isIPTCCompliant() {
        return this == GIF || this == JPG || this == TIFF;
    }

    public static Set<MediaMimeType> getSupportedMimeTypes(MediaType mediaType) {
        Set<MediaMimeType> supportedMimeTypes;
        switch (mediaType) {
            case Photo: {
                supportedMimeTypes = PHOTOS;
                break;
            }
            case Video: {
                supportedMimeTypes = VIDEOS;
                break;
            }
            case Sound: {
                supportedMimeTypes = SOUNDS;
                break;
            }
            default: {
                supportedMimeTypes = EnumSet.noneOf(MediaMimeType.class);
            }
        }
        return supportedMimeTypes;
    }

    static {
        PHOTOS = Collections.unmodifiableSet(EnumSet.of(BMP, GIF, PNG, JPG, TIFF));
        VIDEOS = Collections.unmodifiableSet(EnumSet.of(MOV, MP4, FLV));
        SOUNDS = Collections.unmodifiableSet(EnumSet.of(MP3));
        ALL_VALIDS = EnumSet.allOf(MediaMimeType.class);
        ALL_VALIDS.remove((Object)ERROR);
    }
}

