/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.silverpeas.components.gallery.constant.MediaResolution;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractGlobalSilverContentProcessor;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractSilverpeasContentManager;
import org.silverpeas.core.contribution.contentcontainer.content.GlobalSilverContent;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentInterface;
import org.silverpeas.core.util.Pair;

@Named(value="galleryGlobalSilverContentProcessor")
public class GalleryGlobalSilverpeasContentProcessor
extends AbstractGlobalSilverContentProcessor {
    public String relatedToComponent() {
        return "gallery";
    }

    public Stream<GlobalSilverContent> asGlobalSilverContent(List<SilverContentInterface> silverContents) {
        Map<String, Pair> mediaThumbnails = silverContents.stream().map(c -> (Media)((AbstractSilverpeasContentManager.ContributionWrapper)c).getWrappedInstance()).collect(Collectors.toMap(Media::getId, m -> Pair.of((Object)m.getApplicationThumbnailUrl(MediaResolution.TINY), (Object)((Object)m.getType()))));
        return super.asGlobalSilverContent(silverContents).peek(g -> {
            Pair mediaThumbnail = (Pair)mediaThumbnails.get(g.getId());
            g.setThumbnailURL((String)mediaThumbnail.getFirst());
            g.setType(((MediaType)((Object)((Object)mediaThumbnail.getSecond()))).getName());
        });
    }
}

