/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.components.datawarning.model.DataWarningGroup;
import org.silverpeas.components.datawarning.model.DataWarningQueryResult;
import org.silverpeas.components.datawarning.model.DataWarningResult;
import org.silverpeas.components.datawarning.model.DataWarningUser;
import org.silverpeas.components.datawarning.service.DataWarningEngine;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.NotificationSender;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.ScheduledJob;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.logging.SilverLogger;

public class DataWarningSchedulerImpl {
    public static final String DATAWARNING_JOB_NAME = "DataWarning";
    private static final String MAIL_TITLE_KEY = "titreMail";
    private String instanceId = "";
    private DataWarningEngine dataWarningEngine = null;
    private String[] idAllUniqueUsers = new String[0];
    private ScheduledJob theJob = null;
    private Scheduler scheduler = null;
    private String jobName = null;
    private LocalizationBundle messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.dataWarning.multilang.dataWarning");

    public DataWarningSchedulerImpl(String instanceId) {
        OrganizationController oc = OrganizationControllerProvider.getOrganisationController();
        this.instanceId = instanceId;
        this.jobName = DATAWARNING_JOB_NAME + this.instanceId;
        HashSet<String> hs = new HashSet<String>();
        try {
            this.dataWarningEngine = new DataWarningEngine(instanceId);
            Collection<DataWarningGroup> dataWarningGroups = this.dataWarningEngine.getDataWarningGroups();
            for (DataWarningGroup dataWarningGroup : dataWarningGroups) {
                String idGroup = Integer.toString(dataWarningGroup.getGroupId());
                Group gr = oc.getGroup(idGroup);
                hs.addAll(Arrays.asList(gr.getUserIds()));
            }
            Collection<DataWarningUser> dataWarningUsers = this.dataWarningEngine.getDataWarningUsers();
            for (DataWarningUser dataWarningUser : dataWarningUsers) {
                hs.add(Integer.toString(dataWarningUser.getUserId()));
            }
            this.idAllUniqueUsers = hs.toArray(new String[this.idAllUniqueUsers.length]);
            this.scheduler = SchedulerProvider.getVolatileScheduler();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public void start() {
        try {
            if (this.scheduler.isJobScheduled(this.jobName)) {
                this.scheduler.unscheduleJob(this.jobName);
            }
            String cronExpression = this.dataWarningEngine.getDataWarningScheduler().createCronString();
            Date startDate = new Date(this.dataWarningEngine.getDataWarningScheduler().getWakeUp());
            JobTrigger trigger = JobTrigger.triggerAt((String)cronExpression);
            if (startDate.after(new Date())) {
                trigger.startAt(startDate);
            }
            this.theJob = this.scheduler.scheduleJob(new Job(this.jobName){

                public void execute(JobExecutionContext context) {
                    DataWarningSchedulerImpl.this.doDataWarningSchedulerImpl();
                }
            }, trigger);
            this.dataWarningEngine.updateSchedulerWakeUp(this.theJob.getNextExecutionTime().getTime());
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public void stop() {
        try {
            this.scheduler.unscheduleJob(this.jobName);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error((Throwable)ex);
        }
    }

    public synchronized void doDataWarningSchedulerImpl() {
        DataWarningResult dwr = this.dataWarningEngine.run();
        if (!dwr.hasError()) {
            try {
                OrganizationController oc = OrganizationControllerProvider.getOrganisationController();
                StringBuilder msgForManager = new StringBuilder();
                DataWarningQueryResult dwqr = dwr.getQueryResult();
                String descriptionRequete = dwr.getDataQuery().getDescription();
                StringBuilder msgToSend = new StringBuilder();
                int nbRowMax = this.dataWarningEngine.getDataWarning().getRowLimit();
                if (!descriptionRequete.isEmpty()) {
                    msgToSend.append(descriptionRequete).append("\n\n");
                }
                ArrayList<String> managerDestIds = new ArrayList<String>();
                ArrayList<String> profilesList = new ArrayList<String>();
                profilesList.add("admin");
                profilesList.add("publisher");
                String[] managerIds = oc.getUsersIdsByRoleNames(this.instanceId, profilesList);
                if (this.dataWarningEngine.getDataWarning().getAnalysisType() == 0) {
                    this.processInconditionalQuery(msgForManager, dwqr, msgToSend, nbRowMax, managerDestIds, managerIds);
                } else if (this.dataWarningEngine.getDataWarning().getAnalysisType() == 1) {
                    this.processTriggerAnalysis(dwr, msgForManager, dwqr, msgToSend, nbRowMax, managerDestIds, managerIds);
                }
                for (int i = 0; i < managerDestIds.size(); ++i) {
                    this.sendMessage(this.messages.getString(MAIL_TITLE_KEY), msgToSend.toString() + msgForManager.toString(), (String)managerDestIds.get(i));
                }
                this.dataWarningEngine.updateSchedulerWakeUp(this.theJob.getNextExecutionTime().getTime());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    private void processTriggerAnalysis(DataWarningResult dwr, StringBuilder msgForManager, DataWarningQueryResult dwqr, StringBuilder msgToSend, int nbRowMax, List<String> managerDestIds, String[] managerIds) {
        for (String idAllUniqueUser : this.idAllUniqueUsers) {
            StringBuilder msgByUser = new StringBuilder();
            if (dwr.getTriggerEnabled(idAllUniqueUser)) {
                msgByUser.append(this.messages.getString("resultatSeuilValeur")).append(" : ").append(dwr.getTriggerActualValue(idAllUniqueUser)).append("\n\n");
                msgByUser.append(this.buildResultForMessage(dwqr, nbRowMax, idAllUniqueUser));
                this.sendMessage(this.messages.getString(MAIL_TITLE_KEY), msgToSend.toString() + msgByUser.toString(), idAllUniqueUser);
                String userPersoValue = dwqr.returnPersoValue(idAllUniqueUser);
                UserDetail userDetail = UserDetail.getById((String)idAllUniqueUser);
                msgForManager.append(this.messages.getString("separateurUserMail")).append(userDetail.getDisplayedName()).append(" (").append(userPersoValue).append(") :");
                msgForManager.append((CharSequence)msgByUser).append("\n\n");
            }
            for (String managerId : managerIds) {
                if (!managerId.equals(idAllUniqueUser)) continue;
                managerDestIds.add(managerId);
            }
        }
    }

    private void processInconditionalQuery(StringBuilder msgForManager, DataWarningQueryResult dwqr, StringBuilder msgToSend, int nbRowMax, List<String> managerDestIds, String[] managerIds) {
        for (String idAllUniqueUser : this.idAllUniqueUsers) {
            String resultForMessage = this.buildResultForMessage(dwqr, nbRowMax, idAllUniqueUser);
            if (!resultForMessage.isEmpty()) {
                if (dwqr.isPersoEnabled()) {
                    String userPersoValue = dwqr.returnPersoValue(idAllUniqueUser);
                    UserDetail userDetail = UserDetail.getById((String)idAllUniqueUser);
                    msgForManager.append(this.messages.getString("separateurUserMail")).append(userDetail.getDisplayedName()).append(" (").append(userPersoValue).append(") :\n\n");
                    msgForManager.append(resultForMessage).append("\n\n");
                }
                this.sendMessage(this.messages.getString(MAIL_TITLE_KEY), msgToSend.toString() + resultForMessage, idAllUniqueUser);
            }
            for (String managerId : managerIds) {
                if (!managerId.equals(idAllUniqueUser)) continue;
                managerDestIds.add(managerId);
            }
        }
    }

    private String buildResultForMessage(DataWarningQueryResult dwqr, int nbRowMax, String userId) {
        StringBuilder msgToSend = new StringBuilder();
        String userPersoValue = dwqr.returnPersoValue(userId);
        List cols = dwqr.getPersoColumns();
        int nbCols = cols.size();
        this.setMessageColumns(msgToSend, cols);
        List vals = dwqr.getValues(userId);
        this.setMessageValues(dwqr, nbRowMax, msgToSend, userPersoValue, nbCols, vals);
        if (vals.isEmpty()) {
            return "";
        }
        return msgToSend.toString();
    }

    private void setMessageValues(DataWarningQueryResult dwqr, int nbRowMax, StringBuilder msgToSend, String userPersoValue, int nbCols, List vals) {
        for (int j = 0; j < vals.size() && (nbRowMax <= 0 || j < nbRowMax); ++j) {
            ArrayList theRow = (ArrayList)vals.get(j);
            if (dwqr.isPersoEnabled() && theRow.get(dwqr.getPersoColumnNumber()).equals(userPersoValue)) {
                theRow.remove(dwqr.getPersoColumnNumber());
            }
            for (int k = 0; k < nbCols; ++k) {
                msgToSend.append((String)theRow.get(k));
                if (k + 1 >= nbCols) continue;
                msgToSend.append(" | ");
            }
            msgToSend.append("\n");
        }
    }

    private void setMessageColumns(StringBuilder msgToSend, List cols) {
        Iterator it = cols.iterator();
        while (it.hasNext()) {
            msgToSend.append((String)it.next());
            if (!it.hasNext()) continue;
            msgToSend.append(" | ");
        }
        msgToSend.append("\n");
        int msgToSendLength = msgToSend.toString().length();
        for (int i = 0; i < msgToSendLength; ++i) {
            msgToSend.append("-");
        }
        msgToSend.append("\n");
    }

    private void sendMessage(String title, String msgToSend, String uid) {
        try {
            NotificationMetaData notificationMetaData = new NotificationMetaData(0, title, msgToSend);
            notificationMetaData.addUserRecipient(new UserRecipient(uid));
            notificationMetaData.setSender("0");
            NotificationSender notificationSender = new NotificationSender(this.instanceId);
            notificationSender.notifyUser(notificationMetaData);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }
}

