/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.info;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.gradle.internal.classpath.Instrumented;

public abstract class JVMInfo {
    public static final int JDK_ID;
    public static final int J2SE_18 = 9;

    public static int jdbcMajorVersion() {
        return 4;
    }

    public static int jdbcMinorVersion() {
        switch (JDK_ID) {
            default: 
        }
        return 2;
    }

    public static String derbyVMLevel() {
        String string = JVMInfo.jdbcMajorVersion() + "." + JVMInfo.jdbcMinorVersion();
        switch (JDK_ID) {
            case 9: {
                return "Java SE 8 - JDBC " + string;
            }
        }
        return "?-?";
    }

    private static String getSystemProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Instrumented.systemProperty((String)string, (String)"org.apache.derby.iapi.services.info.JVMInfo$1");
            }
        });
    }

    public static final boolean isSunJVM() {
        String string = JVMInfo.getSystemProperty("java.vendor");
        return "Sun Microsystems Inc.".equals(string) || "Oracle Corporation".equals(string);
    }

    public static final boolean isIBMJVM() {
        return "IBM Corporation".equals(JVMInfo.getSystemProperty("java.vendor"));
    }

    public static void javaDump() {
        if (JVMInfo.isIBMJVM()) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.ibm.jvm.Dump");
                final Method method = clazz.getMethod("JavaDump", new Class[0]);
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IllegalAccessException, MalformedURLException, InstantiationException, InvocationTargetException {
                        return method.invoke(null, new Object[0]);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean hasJNDI() {
        try {
            Class.forName("javax.naming.Referenceable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    static {
        int n;
        String string = "1.8";
        try {
            string = Instrumented.systemProperty((String)"java.specification.version", (String)string, (String)"org.apache.derby.iapi.services.info.JVMInfo");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string.equals("1.8")) {
            n = 9;
        } else {
            n = 9;
            try {
                int n2;
                String[] stringArray = string.split("[.]");
                int n3 = stringArray.length >= 1 ? Integer.parseInt(stringArray[0]) : 0;
                int n4 = n2 = stringArray.length >= 2 ? Integer.parseInt(stringArray[1]) : 0;
                if (n3 > 1 || n3 == 1 && n2 >= 8) {
                    n = 9;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        JDK_ID = n;
    }
}

