/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.gradle.internal.classpath.Instrumented;

public final class URLCoder {
    private static final String ENCODING_FOR_URL = Instrumented.systemProperty((String)"postgresql.url.encoding", (String)"UTF-8", (String)"org.postgresql.util.URLCoder");

    public static String decode(String encoded) {
        try {
            return URLDecoder.decode(encoded, ENCODING_FOR_URL);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to decode URL entry via " + ENCODING_FOR_URL + ". This should not happen", e);
        }
    }

    public static String encode(String plain) {
        try {
            return URLEncoder.encode(plain, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to encode URL entry via " + ENCODING_FOR_URL + ". This should not happen", e);
        }
    }
}

