/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.hateoas.referenceable;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import edu.psu.swe.commons.jaxrs.hateoas.referenceable.Referenceable;
import edu.psu.swe.commons.jaxrs.hateoas.referenceable.ReferenceableAtomLink;
import edu.psu.swe.commons.jaxrs.hateoas.referenceable.RequestBean;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceableSerializer
extends JsonSerializer<Referenceable> {
    private static final Logger log = LoggerFactory.getLogger(ReferenceableSerializer.class);
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceableSerializer.class);

    public void serialize(Referenceable value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        LOG.debug("Serializing list of referenceable into referenceable atom links");
        ReferenceableAtomLink ral = value.convertToReferenceableType();
        String basePath = null;
        try {
            RequestBean requestBean = (RequestBean)CDI.current().select(RequestBean.class, new Annotation[0]).get();
            basePath = requestBean.getRequest().getScheme() + "://" + requestBean.getRequest().getServerName() + ":" + requestBean.getRequest().getServerPort() + requestBean.getRequest().getContextPath() + "/resources";
        }
        catch (IllegalStateException ex) {
            log.warn("no access to CDI");
        }
        gen.writeStartObject();
        gen.writeStringField("id", ral.getId());
        gen.writeStringField("type", ral.getMimeType());
        if (basePath != null) {
            gen.writeStringField("href", basePath + ral.getHyperlink());
        }
        gen.writeEndObject();
    }

    public void serializeWithType(Referenceable value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        LOG.debug("type Serializing list of referenceable into referenceable atom links");
        ReferenceableAtomLink ral = value.convertToReferenceableType();
        String basePath = null;
        try {
            RequestBean requestBean = (RequestBean)CDI.current().select(RequestBean.class, new Annotation[0]).get();
            basePath = requestBean.getRequest().getScheme() + "://" + requestBean.getRequest().getServerName() + ":" + requestBean.getRequest().getServerPort() + requestBean.getRequest().getContextPath() + "/resources";
        }
        catch (IllegalStateException ex) {
            log.warn("no access to CDI");
        }
        gen.writeStartObject();
        gen.writeStringField("id", ral.getId());
        gen.writeStringField("type", ral.getMimeType());
        if (basePath != null) {
            gen.writeStringField("href", basePath + ral.getHyperlink());
        }
        gen.writeEndObject();
    }
}

