/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.scheduleevent.service.model.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="sc_scheduleevent_options")
public class DateOption
implements Comparable<DateOption>,
Serializable {
    public static final int MORNING_BEGIN_HOUR = 8;
    public static final int MORNING_END_HOUR = 12;
    public static final int AFTERNOON_BEGIN_HOUR = 14;
    public static final int AFTERNOON_END_HOUR = 18;
    @Id
    private String id;
    @Column(name="optionday")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date day;
    @Column(name="optionhour")
    private int hour;

    @PrePersist
    protected void setUpId() {
        this.id = UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getDay() {
        return this.day;
    }

    public void setDay(Date day) {
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.day == null ? 0 : this.day.hashCode());
        result = 31 * result + (this.hour ^ this.hour >>> 31);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateOption option = (DateOption)obj;
        return this.day.equals(option.getDay()) && this.hour == option.getHour();
    }

    @Override
    public int compareTo(DateOption obj) {
        if (this.equals(obj)) {
            return 0;
        }
        if (this.day.equals(obj.getDay())) {
            if (this.hour > obj.getHour()) {
                return 1;
            }
            return -1;
        }
        return this.day.compareTo(obj.getDay());
    }
}

