/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo.notification;

import java.io.File;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.silverpeas.components.quickinfo.model.News;
import org.silverpeas.components.quickinfo.model.QuickInfoService;
import org.silverpeas.components.quickinfo.notification.QuickInfoDelayedVisibilityUserNotificationReminder;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.file.FileRepositoryManager;

@Service
public class QuickInfoDelayedVisibilityUserNotificationReminderInitializer
implements Initialization {
    private File dataFile = new File(FileRepositoryManager.getInitDataDirPath(), "quickInfoDelayedVisibilityReminderInitialization");
    @Inject
    private QuickInfoDelayedVisibilityUserNotificationReminder delayedVisibilityUserNotificationReminder;

    public void init() throws Exception {
        if (!this.dataFile.exists()) {
            ListSlice potentialNewsIds = JdbcSqlQuery.createSelect((String)"n.id", (Object[])new Object[0]).from(new String[]{"sc_quickinfo_news n, sb_publication_publi p"}).where("CAST(n.foreignid AS INT) = p.pubid", new Object[0]).and("p.pubbegindate >= ?", new Object[]{DateUtil.today2SQLDate()}).execute(r -> r.getString(1));
            StringBuilder report = new StringBuilder((potentialNewsIds.size() + 1) * 180);
            try {
                if (potentialNewsIds.isEmpty()) {
                    report.append("No reminder has been set about delayed visibility.");
                } else {
                    potentialNewsIds.forEach(i -> {
                        News potentialNews = QuickInfoService.get().getNews((String)i);
                        if (this.delayedVisibilityUserNotificationReminder.setAbout(potentialNews)) {
                            report.append(MessageFormat.format("Reminder set for news with id {0}, located into instance {1}, linked to publication {2}, with visibility set to {3} at {4}\n", potentialNews.getId(), potentialNews.getComponentInstanceId(), potentialNews.getPublicationId(), LocalDateTime.ofInstant(potentialNews.getPublication().getBeginDate().toInstant(), ZoneId.systemDefault()).toLocalDate(), potentialNews.getPublication().getBeginHour()));
                        }
                    });
                }
            }
            finally {
                FileUtils.write((File)this.dataFile, (CharSequence)report.toString(), (Charset)Charsets.UTF_8);
            }
        }
    }
}

