/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.viewer.service;

import java.io.File;
import org.silverpeas.core.SilverpeasRuntimeException;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.io.temp.TemporaryWorkspaceTranslation;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.viewer.model.ViewerSettings;

public class ViewerContext
implements Cloneable {
    private final String documentId;
    private final String originalFileName;
    private final File originalSourceFile;
    private final String language;
    private String initializerProcessName;
    private String uniqueDocumentId = String.valueOf(System.nanoTime());
    private boolean cacheRequired = false;
    private boolean processingCache = false;

    public static ViewerContext from(SimpleDocument document) {
        String contentLanguage = document.getLanguage();
        return new ViewerContext(document.getId(), document.getFilename(), new File(document.getAttachmentPath()), contentLanguage).withUniqueDocumentId(contentLanguage + "-" + document.getId());
    }

    protected ViewerContext(String documentId, String originalFileName, File originalSourceFile, String language) {
        this.documentId = documentId;
        this.originalFileName = originalFileName;
        this.originalSourceFile = originalSourceFile;
        this.language = language;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public File getOriginalSourceFile() {
        return this.originalSourceFile;
    }

    ViewerContext fromInitializerProcessName(String initializerProcessName) {
        this.initializerProcessName = initializerProcessName;
        return this;
    }

    public TemporaryWorkspaceTranslation getWorkspace() {
        return TemporaryWorkspaceTranslation.from((String)this.getViewId());
    }

    public String getViewId() {
        return this.initializerProcessName + "-" + this.uniqueDocumentId;
    }

    public ViewerContext withUniqueDocumentId(String uniqueDocumentId) {
        if (ViewerSettings.isCacheEnabled() && StringUtil.isDefined((String)uniqueDocumentId)) {
            this.uniqueDocumentId = uniqueDocumentId;
            this.cacheRequired = true;
        }
        return this;
    }

    public boolean isCacheRequired() {
        return this.cacheRequired;
    }

    public boolean isProcessingCache() {
        return this.processingCache;
    }

    public void processingCache() {
        this.processingCache = true;
    }

    public String getLanguage() {
        return this.language;
    }

    protected ViewerContext clone() {
        try {
            ViewerContext clonedViewerContext = (ViewerContext)super.clone();
            clonedViewerContext.initializerProcessName = "";
            clonedViewerContext.processingCache = false;
            return clonedViewerContext;
        }
        catch (CloneNotSupportedException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }
}

