/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.rs;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.core.security.authorization.SimpleDocumentAccessControl;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionValidationContext;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.web.rs.HTTPAuthentication;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;

@Service
public class UserPrivilegeValidator
implements UserPrivilegeValidation {
    @Inject
    private SessionManagement sessionManager;
    @Inject
    private ComponentAccessControl componentAccessController;
    @Inject
    private SimpleDocumentAccessControl documentAccessController;
    @Inject
    private PublicationAccessControl publicationAccessController;
    @Inject
    private OrganizationController organizationController;
    @Inject
    private HTTPAuthentication authentication;
    private static final String SKIP_LAST_USER_ACCESS_TIME_REGISTERING = "SKIP_LAST_USER_ACCESS_TIME_REGISTERING";

    @Override
    public SessionInfo validateUserAuthentication(HttpServletRequest request, HttpServletResponse response) {
        SessionInfo userSession = SessionInfo.NoneSession;
        String sessionKey = this.getUserSessionKey(request);
        if (StringUtil.isDefined((String)sessionKey)) {
            SessionValidationContext sessionValidationContext = SessionValidationContext.withSessionKey((String)sessionKey);
            if (this.mustSkipLastUserAccessTimeRegistering(request)) {
                sessionValidationContext.skipLastUserAccessTimeRegistering();
            }
            userSession = this.validateUserSession(sessionValidationContext);
            response.setHeader("X-Silverpeas-Session", userSession.getSessionId());
        }
        if (!userSession.isDefined()) {
            userSession = this.authentication.authenticate(new HTTPAuthentication.AuthenticationContext(request, response));
        }
        return userSession;
    }

    @Override
    public UserPrivilegeValidation skipLastUserAccessTimeRegistering(HttpServletRequest request) {
        request.setAttribute(SKIP_LAST_USER_ACCESS_TIME_REGISTERING, (Object)true);
        return this;
    }

    private boolean mustSkipLastUserAccessTimeRegistering(HttpServletRequest request) {
        return request.getAttribute(SKIP_LAST_USER_ACCESS_TIME_REGISTERING) != null;
    }

    @Override
    public void validateUserAuthorizationOnComponentInstance(User user, String instanceId) {
        SilverpeasComponentInstance instance = (SilverpeasComponentInstance)this.organizationController.getComponentInstance(instanceId).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
        if (user == null || !this.componentAccessController.isUserAuthorized(user.getId(), (Object)instance.getId())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    @Override
    public void validateUserAuthorizationOnAttachment(HttpServletRequest request, User user, SimpleDocument doc) {
        AccessControlContext context = AccessControlContext.init();
        if ("PUT".equals(request.getMethod())) {
            context.onOperationsOf(new AccessControlOperation[]{AccessControlOperation.CREATION});
        } else if ("POST".equals(request.getMethod())) {
            context.onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION});
        } else if ("DELETE".equals(request.getMethod())) {
            context.onOperationsOf(new AccessControlOperation[]{AccessControlOperation.DELETION});
        }
        if (!this.documentAccessController.isUserAuthorized(user.getId(), (Object)doc, context)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    @Override
    public void validateUserAuthorizationOnPublication(HttpServletRequest request, User user, PublicationDetail publi) {
        AccessControlContext context = AccessControlContext.init();
        if (!this.publicationAccessController.isUserAuthorized(user.getId(), publi, context)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    private String getUserSessionKey(HttpServletRequest request) {
        HttpSession httpSession;
        String sessionKey = request.getHeader("X-Silverpeas-Session");
        if (StringUtil.isNotDefined((String)sessionKey)) {
            sessionKey = request.getParameter("X-Silverpeas-Session");
        }
        if (!StringUtil.isDefined((String)sessionKey) && (httpSession = request.getSession(false)) != null) {
            sessionKey = httpSession.getId();
        }
        return sessionKey;
    }

    private SessionInfo validateUserSession(SessionValidationContext context) {
        SessionInfo sessionInfo = this.sessionManager.validateSession(context);
        if (!sessionInfo.isDefined() && UserDetail.isAnonymousUserExist()) {
            sessionInfo = new SessionInfo(null, (User)UserDetail.getAnonymousUser());
        }
        return sessionInfo;
    }
}

