/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.notification;

import java.util.Collection;
import java.util.function.Predicate;
import org.silverpeas.components.kmelia.notification.AbstractKmeliaPublicationUserNotification;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.subscription.LocationFilterDirective;
import org.silverpeas.core.contribution.publication.subscription.OnLocationDirective;
import org.silverpeas.core.contribution.publication.subscription.PublicationAliasSubscriptionResource;
import org.silverpeas.core.contribution.publication.subscription.PublicationSubscriptionResource;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.user.UserSubscriptionNotificationBehavior;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.subscription.SubscriberDirective;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.service.ResourceSubscriptionProvider;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberMapBySubscriberType;

public class KmeliaSubscriptionPublicationUserNotification
extends AbstractKmeliaPublicationUserNotification
implements UserSubscriptionNotificationBehavior {
    private final SubscriptionSubscriberMapBySubscriberType subscriberIdsByTypes;

    public KmeliaSubscriptionPublicationUserNotification(NodePK nodePK, PublicationDetail resource, NotifAction action) {
        super(nodePK, resource, action);
        if (((PublicationDetail)this.getResource()).isAlias()) {
            this.subscriberIdsByTypes = ResourceSubscriptionProvider.getSubscribersOfSubscriptionResource((SubscriptionResource)PublicationAliasSubscriptionResource.from((PublicationPK)new PublicationPK(resource.getId(), this.getNodePK().getComponentInstanceId())), (SubscriberDirective[])new SubscriberDirective[]{OnLocationDirective.onLocationId((String)this.getNodePK().getLocalId())}).indexBySubscriberType();
        } else {
            LocationFilterDirective filter = LocationFilterDirective.withLocationFilter(Predicate.not(Location::isAlias).and(l -> l.getComponentInstanceId().equals(this.getComponentInstanceId())));
            this.subscriberIdsByTypes = ResourceSubscriptionProvider.getSubscribersOfSubscriptionResource((SubscriptionResource)PublicationSubscriptionResource.from((PublicationPK)resource.getPK()), (SubscriberDirective[])new SubscriberDirective[]{filter}).indexBySubscriberType();
        }
    }

    protected void perform(PublicationDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    protected String getBundleSubjectKey() {
        return "Subscription";
    }

    protected String getTemplateFileName() {
        if (NotifAction.CREATE.equals((Object)this.getAction())) {
            return "notificationSubscriptionCreate";
        }
        if (NotifAction.UPDATE.equals((Object)this.getAction())) {
            return "notificationSubscriptionUpdate";
        }
        return "notificationSubscriptionOtherAction";
    }

    protected Collection<String> getUserIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.USER)).getAllIds();
    }

    protected Collection<String> getGroupIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.GROUP)).getAllIds();
    }
}

