/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.constant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.silverpeas.components.gallery.GalleryComponentSettings;
import org.silverpeas.core.util.StringUtil;

public enum MediaResolution {
    TINY(true, "66x50", 66, 50, "66x50"),
    SMALL(true, "133x100", 133, 100, "133x100"),
    MEDIUM(true, "266x150", 266, 150, "266x150"),
    LARGE(false, "600x400", 600, 400, null),
    PREVIEW(false, "preview", 600, 400, "600x400"),
    NORMAL(false, "normal", null, null, null),
    WATERMARK(false, "watermark", null, null, null),
    ORIGINAL(false, "original", null, null, null);

    public static final Set<MediaResolution> ALL;
    private final boolean displayed;
    private final String label;
    private final Integer width;
    private final Integer height;
    private final String thumbnailSuffix;
    private final Integer watermarkSize;

    private MediaResolution(boolean displayed, String label, Integer width, Integer height, String bundlePartOfWaterwarkSizeLabel) {
        this.displayed = displayed;
        this.label = label;
        this.width = width;
        this.height = height;
        this.watermarkSize = GalleryComponentSettings.getWatermarkSize(bundlePartOfWaterwarkSizeLabel);
        this.thumbnailSuffix = "original".equals(label) ? "" : "_" + label;
    }

    @JsonCreator
    public static MediaResolution fromNameOrLabel(String nameOrLabel) {
        MediaResolution result = null;
        for (MediaResolution mediaResolution : MediaResolution.values()) {
            if (!mediaResolution.name().equalsIgnoreCase(nameOrLabel) && (!StringUtil.isDefined((String)mediaResolution.getLabel()) || !nameOrLabel.contains(mediaResolution.getLabel()))) continue;
            result = mediaResolution;
            break;
        }
        return result;
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public String getLabel() {
        return this.label;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public String getThumbnailSuffix() {
        return this.thumbnailSuffix;
    }

    public boolean isWatermarkApplicable() {
        return this.watermarkSize != null;
    }

    public Integer getWatermarkSize() {
        return this.watermarkSize;
    }

    public boolean isTiny() {
        return this == TINY;
    }

    public boolean isSmall() {
        return this == SMALL;
    }

    public boolean isMedium() {
        return this == MEDIUM;
    }

    public boolean isLarge() {
        return this == LARGE;
    }

    public boolean isPreview() {
        return this == PREVIEW;
    }

    public boolean isWatermark() {
        return this == WATERMARK;
    }

    static {
        ALL = Collections.unmodifiableSet(EnumSet.allOf(MediaResolution.class));
    }
}

