/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalorganizer.model;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import org.silverpeas.core.personalorganizer.model.Classification;
import org.silverpeas.core.personalorganizer.model.Priority;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;

public abstract class Schedulable
implements Serializable {
    private static final long serialVersionUID = -4783278450365830294L;
    private static final int MILLIS_IN_MINUTE = 60000;
    private static final int MILLIS_IN_HOUR = 3600000;
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int DIGIT_COUNT = 2;
    private String id = null;
    private String name = null;
    private String delegatorId = null;
    private String description = null;
    private Classification classification = null;
    private String startDate = null;
    private String startHour = null;
    private String endDate = null;
    private String endHour = null;
    private Priority priority = null;
    private String externalId = null;

    public Schedulable() {
    }

    public Schedulable(String name, String delegatorId) {
        if (StringUtil.isDefined((String)name)) {
            this.name = name;
        }
        if (StringUtil.isDefined((String)delegatorId)) {
            this.delegatorId = delegatorId;
        }
    }

    public Schedulable(String id, String name, String delegatorId) {
        this(name, delegatorId);
        this.id = id;
    }

    public abstract Schedulable getCopy();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.isDefined((String)name) ? name : null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = StringUtil.isDefined((String)id) ? id : null;
    }

    public void setDelegatorId(String delegatorId) {
        this.delegatorId = StringUtil.isDefined((String)delegatorId) ? delegatorId : null;
    }

    public String getDelegatorId() {
        return this.delegatorId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Classification getClassification() {
        if (this.classification == null) {
            this.classification = new Classification();
        }
        return this.classification;
    }

    public Priority getPriority() {
        if (this.priority == null) {
            this.priority = new Priority();
        }
        return this.priority;
    }

    public void setStartDay(String date) throws ParseException {
        if (date == null) {
            this.startDate = null;
            return;
        }
        if (date.length() == 0) {
            this.startDate = null;
            return;
        }
        DateUtil.parseDate((String)date);
        this.startDate = date;
    }

    public void setStartHour(String hour) throws ParseException {
        if (hour == null) {
            this.startHour = null;
            return;
        }
        if (hour.length() == 0) {
            this.startHour = null;
            return;
        }
        DateUtil.parseTime((String)hour);
        this.startHour = hour;
    }

    public String getStartDay() {
        return this.startDate;
    }

    public Date getStartDate() {
        if (this.getStartDay() == null) {
            return null;
        }
        try {
            if (this.getStartHour() == null) {
                return DateUtil.parseDate((String)this.getStartDay());
            }
            return DateUtil.parseDateTime((String)(this.getStartDay() + " " + this.getStartHour()));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setStartDate(Date start) {
        if (start == null) {
            this.startDate = null;
            return;
        }
        this.startDate = DateUtil.formatDate((Date)start);
    }

    public String getStartHour() {
        return this.startHour;
    }

    public void setEndDay(String date) throws ParseException {
        if (!StringUtil.isDefined((String)date)) {
            this.endDate = null;
            return;
        }
        DateUtil.parseDate((String)date);
        this.endDate = date;
    }

    public void setEndHour(String hour) throws ParseException {
        if (hour == null) {
            this.endHour = null;
            return;
        }
        if (hour.length() == 0) {
            this.endHour = null;
            return;
        }
        DateUtil.parseTime((String)hour);
        this.endHour = hour;
    }

    public String getEndDay() {
        return this.endDate;
    }

    public String getEndHour() {
        return this.endHour;
    }

    public Date getEndDate() {
        if (this.getEndDay() == null) {
            return null;
        }
        try {
            if (this.getEndHour() != null) {
                return DateUtil.parseDateTime((String)(this.getEndDay() + " " + this.getEndHour()));
            }
            return DateUtil.parseDate((String)this.getEndDay());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setEndDate(Date end) {
        if (end == null) {
            this.endDate = null;
            return;
        }
        this.endDate = DateUtil.formatDate((Date)end);
    }

    public String getStringDuration() {
        try {
            Date aStartDate = DateUtil.parseDateTime((String)(this.getStartDay() + " " + this.getStartHour()));
            Date anEndDate = DateUtil.parseDateTime((String)(this.getEndDay() + " " + this.getEndHour()));
            long ms = anEndDate.getTime() - aStartDate.getTime();
            return Schedulable.hourMinuteToString((int)(ms / 60000L % 60L), (int)(ms / 3600000L));
        }
        catch (ParseException e) {
            SilverLogger.getLogger((Object)this).warn("Error while parsing the time. Return 00:00. Error is: " + e.getMessage(), new Object[0]);
            return "00:00";
        }
    }

    public int getMinuteDuration() {
        try {
            Date aStartDate = DateUtil.parseDateTime((String)(this.getStartDay() + " " + this.getStartHour()));
            Date anEndDate = DateUtil.parseDateTime((String)(this.getEndDay() + " " + this.getEndHour()));
            long ms = anEndDate.getTime() - aStartDate.getTime();
            return (int)(ms / 60000L);
        }
        catch (ParseException e) {
            SilverLogger.getLogger((Object)this).warn("Error while parsing the minutes. Return 0. Error is: " + e.getMessage(), new Object[0]);
            return 0;
        }
    }

    public boolean isOver(Schedulable schedule) {
        if (this.isOverHour(schedule)) {
            return false;
        }
        if (this.getStartDate().compareTo(schedule.getStartDate()) <= 0 && this.getEndDate().compareTo(schedule.getStartDate()) > 0) {
            return true;
        }
        if (this.getStartDate().compareTo(schedule.getEndDate()) < 0 && this.getEndDate().compareTo(schedule.getEndDate()) >= 0) {
            return true;
        }
        if (schedule.getStartDate().compareTo(this.getStartDate()) <= 0 && schedule.getEndDate().compareTo(this.getStartDate()) > 0) {
            return true;
        }
        return schedule.getStartDate().compareTo(this.getEndDate()) < 0 && schedule.getEndDate().compareTo(this.getEndDate()) >= 0;
    }

    private boolean isOverHour(Schedulable schedule) {
        if (this.getStartHour() == null || this.getEndHour() == null) {
            return true;
        }
        return schedule.getStartHour() == null || schedule.getEndHour() == null;
    }

    public String toString() {
        return " id = " + this.getId() + " name = " + this.getName() + " delegatorId = " + this.getDelegatorId() + " description = " + this.getDescription() + " startDay = " + this.getStartDay() + " startHour = " + this.getStartHour() + " endDay = " + this.getEndDay() + " endHour = " + this.getEndHour() + " externalId = " + this.getExternalId();
    }

    public static String hourMinuteToString(int hour, int minute) {
        Object m;
        Object h = String.valueOf(hour);
        if (((String)h).length() < 2) {
            h = "0" + (String)h;
        }
        if (((String)(m = String.valueOf(minute))).length() < 2) {
            m = "0" + (String)m;
        }
        return (String)h + ":" + (String)m;
    }

    public static String quarterCountToHourString(int quarterCount) {
        Object minute;
        int by2 = 2;
        int mask = 3;
        int quarter = 15;
        Object hour = String.valueOf(quarterCount >> 2);
        if (((String)hour).length() < 2) {
            hour = "0" + (String)hour;
        }
        if (((String)(minute = String.valueOf((quarterCount & 3) * 15))).length() < 2) {
            minute = "0" + (String)minute;
        }
        return (String)hour + ":" + (String)minute;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String outlookId) {
        this.externalId = outlookId;
    }
}

