/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.silverpeas.components.formsonline.model.AbstractFormsOnlineIT;
import org.silverpeas.components.formsonline.model.FormDetail;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.model.FormInstanceValidation;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.components.formsonline.model.FormInstanceValidations;
import org.silverpeas.components.formsonline.model.FormPK;
import org.silverpeas.components.formsonline.model.FormsOnlineDAOJdbc;
import org.silverpeas.components.formsonline.model.FormsOnlineException;
import org.silverpeas.components.formsonline.model.RequestCriteria;
import org.silverpeas.components.formsonline.model.RequestPK;
import org.silverpeas.components.formsonline.model.RequestValidationCriteria;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.contribution.model.ContributionValidation;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.test.BasicWarBuilder;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.core.util.SilverpeasList;

@RunWith(value=Arquillian.class)
public class FormsOnlineDAOJdbcIT
extends AbstractFormsOnlineIT {
    @Inject
    private FormsOnlineDAOJdbc dao;

    @Deployment
    public static Archive<?> createTestArchive() {
        return BasicWarBuilder.onWarForTestClass(FormsOnlineDAOJdbcIT.class).testFocusedOn(warBuilder -> {
            warBuilder.addMavenDependenciesWithPersistence(new String[]{"org.silverpeas.core:silverpeas-core"});
            warBuilder.addMavenDependencies(new String[]{"org.silverpeas.core.services:silverpeas-core-tagcloud"});
            warBuilder.addPackages(true, new String[]{"org.silverpeas.components.formsonline"});
        }).build();
    }

    @Test
    public void testCreateForm() throws Exception {
        FormDetail formDetail = new FormDetail();
        formDetail.setInstanceId("formsOnline15");
        formDetail.setCreatorId("0");
        formDetail.setName("Demande de construction de salle...");
        formDetail.setState(1);
        formDetail.setTitle("Titre");
        formDetail.setXmlFormName("descriptif_salle.xml");
        FormDetail result = this.dao.createForm(formDetail);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.sameInstance((Object)formDetail));
        MatcherAssert.assertThat((Object)result.getId(), (Matcher)Matchers.is((Object)1002));
        result = this.dao.getForm(formDetail.getPK());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)formDetail)));
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)Matchers.is((Object)"Demande de construction de salle..."));
        MatcherAssert.assertThat((Object)result.getState(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)result.getTitle(), (Matcher)Matchers.is((Object)"Titre"));
        MatcherAssert.assertThat((Object)result.getXmlFormName(), (Matcher)Matchers.is((Object)"descriptif_salle.xml"));
        MatcherAssert.assertThat((Object)result.isHierarchicalValidation(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)result.getRequestExchangeReceiver().isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)result.isDeleteAfterRequestExchange(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testCreateFormWithHierarchicalValidation() throws Exception {
        FormDetail formDetail = new FormDetail();
        formDetail.setInstanceId("formsOnline15");
        formDetail.setCreatorId("0");
        formDetail.setName("Demande de construction de salle...");
        formDetail.setState(1);
        formDetail.setTitle("Titre");
        formDetail.setXmlFormName("descriptif_salle.xml");
        formDetail.setHierarchicalValidation(true);
        this.dao.createForm(formDetail);
        FormDetail result = this.dao.getForm(formDetail.getPK());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)formDetail)));
        MatcherAssert.assertThat((Object)result.isHierarchicalValidation(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testCreateFormByDeletingRequestAfterExchangeButNoReceiver() throws Exception {
        FormDetail formDetail = new FormDetail();
        formDetail.setInstanceId("formsOnline15");
        formDetail.setCreatorId("0");
        formDetail.setName("Demande de construction de salle...");
        formDetail.setState(0);
        formDetail.setTitle("Titre");
        formDetail.setXmlFormName("descriptif_salle.xml");
        formDetail.setDeleteAfterRequestExchange(true);
        this.dao.createForm(formDetail);
        FormDetail result = this.dao.getForm(formDetail.getPK());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)formDetail)));
        MatcherAssert.assertThat((Object)result.getRequestExchangeReceiver().isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)result.isDeleteAfterRequestExchange(), (Matcher)Matchers.is((Object)false));
        boolean deleteAfterRequestExchange = (Boolean)FieldUtils.readDeclaredField((Object)result, (String)"deleteAfterRequestExchange", (boolean)true);
        MatcherAssert.assertThat((Object)deleteAfterRequestExchange, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testCreateFormByDeletingRequestAfterExchangeWithReceiver() throws Exception {
        FormDetail formDetail = new FormDetail();
        formDetail.setInstanceId("formsOnline15");
        formDetail.setCreatorId("0");
        formDetail.setName("Demande de construction de salle...");
        formDetail.setState(1);
        formDetail.setTitle("Titre");
        formDetail.setXmlFormName("descriptif_salle.xml");
        formDetail.setRequestExchangeReceiver("toto@silverpeas.org");
        formDetail.setDeleteAfterRequestExchange(true);
        this.dao.createForm(formDetail);
        FormDetail result = this.dao.getForm(formDetail.getPK());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)formDetail)));
        MatcherAssert.assertThat((Object)result.getRequestExchangeReceiver().orElse(null), (Matcher)Matchers.is((Object)"toto@silverpeas.org"));
        MatcherAssert.assertThat((Object)result.isDeleteAfterRequestExchange(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetForm() throws Exception {
        int formId = 1000;
        FormDetail expResult = this.getFormDetailExpectedResult();
        FormDetail result = this.dao.getForm(new FormPK(formId, "formsOnline100"));
        MatcherAssert.assertThat((Object)expResult.equals((Object)result), (Matcher)Matchers.is((Object)true));
    }

    private FormDetail getFormDetailExpectedResult() {
        FormDetail expResult = new FormDetail();
        expResult.setId(1000);
        expResult.setCreatorId("1");
        expResult.setCreationDate((Date)Timestamp.valueOf("2012-01-09 00:00:00.0"));
        expResult.setDescription("Formulaire de description d'une salle");
        expResult.setInstanceId("formsOnline100");
        expResult.setName("R\u00e9f\u00e9rencement des salles");
        expResult.setState(1);
        expResult.setTitle("Titre de mon formulaire en ligne");
        expResult.setXmlFormName("descriptif_salle.xml");
        return expResult;
    }

    @Test
    public void testFindAllForms() throws Exception {
        List result = this.dao.findAllForms("formsOnline100", "name");
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testDeleteForm() throws Exception {
        List result = this.dao.findAllForms("formsOnline100", "name");
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)2));
        FormPK formPk = ((FormDetail)result.iterator().next()).getPK();
        Transaction.performInOne(() -> {
            FormsOnlineDAOJdbc formsOnlineDAOJdbc = this.dao;
            for (FormInstance formInstance : this.dao.getAllRequests(formPk)) {
                RequestPK pk = formInstance.getPK();
                formsOnlineDAOJdbc.deleteRequest(pk);
            }
            return this.dao.deleteForm(formPk);
        });
        result = this.dao.findAllForms("formsOnline100", "name");
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testUpdateForm() throws Exception {
        FormDetail curForm = this.getFormDetailExpectedResult();
        curForm.setDescription("Formulaire de description d'une salle UPDATED");
        curForm.setName("R\u00e9f\u00e9rencement des salles");
        curForm.setState(2);
        curForm.setTitle("Titre de mon formulaire en ligne UPDATED");
        curForm.setXmlFormName("descriptif_salle.xml UPDATED");
        curForm.setHierarchicalValidation(true);
        curForm.setRequestExchangeReceiver("toto@silverpeas.org");
        curForm.setDeleteAfterRequestExchange(true);
        this.dao.updateForm(curForm);
        FormDetail updatedForm = this.dao.getForm(curForm.getPK());
        MatcherAssert.assertThat((Object)curForm.equals((Object)updatedForm), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)updatedForm.getRequestExchangeReceiver().orElse(null), (Matcher)Matchers.is((Object)"toto@silverpeas.org"));
    }

    @Test
    public void testCreateRequest() throws FormsOnlineException {
        FormPK formPK = new FormPK(1000, "formsOnline100");
        MatcherAssert.assertThat((Object)this.dao.getAllRequests(formPK), (Matcher)Matchers.hasSize((int)1));
        FormInstance request = new FormInstance();
        request.setFormId(1000);
        request.setState(1);
        request.setCreatorId(DEFAULT_CREATOR_IDS[0]);
        Timestamp oldDate = Timestamp.valueOf("2019-01-01 00:00:00.0");
        request.setCreationDate((Date)oldDate);
        request.setInstanceId("formsOnline100");
        Transaction.performInOne(() -> this.dao.saveRequest(request));
        MatcherAssert.assertThat((Object)this.dao.getAllRequests(formPK), (Matcher)Matchers.hasSize((int)2));
        FormInstance savedRequest = this.dao.getRequest(request.getPK());
        MatcherAssert.assertThat((Object)savedRequest.getId(), (Matcher)Matchers.is((Object)request.getId()));
        MatcherAssert.assertThat((Object)savedRequest.getFormId(), (Matcher)Matchers.is((Object)request.getFormId()));
        MatcherAssert.assertThat((Object)savedRequest.getState(), (Matcher)Matchers.is((Object)request.getState()));
        MatcherAssert.assertThat((Object)savedRequest.getCreatorId(), (Matcher)Matchers.is((Object)request.getCreatorId()));
        MatcherAssert.assertThat((Object)savedRequest.getComponentInstanceId(), (Matcher)Matchers.is((Object)request.getComponentInstanceId()));
        MatcherAssert.assertThat((Object)savedRequest.getCreationDate(), (Matcher)Matchers.greaterThan((Comparable)request.getCreationDate()));
        MatcherAssert.assertThat((Object)savedRequest.getValidations(), (Matcher)Matchers.empty());
    }

    @Test
    public void testCreateRequestWithValidations() throws FormsOnlineException {
        FormPK formPK = new FormPK(1000, "formsOnline100");
        MatcherAssert.assertThat((Object)this.dao.getAllRequests(formPK), (Matcher)Matchers.hasSize((int)1));
        FormInstance request = new FormInstance();
        request.setFormId(1000);
        request.setState(1);
        request.setCreatorId(DEFAULT_CREATOR_IDS[0]);
        Timestamp oldDate = Timestamp.valueOf("2019-01-01 00:00:00.0");
        request.setCreationDate((Date)oldDate);
        request.setInstanceId("formsOnline100");
        FormInstanceValidation validation1 = new FormInstanceValidation(request);
        validation1.setValidationBy("30");
        validation1.setDate((Date)Timestamp.valueOf("2020-01-01 06:54:23.26"));
        validation1.setValidationType(FormInstanceValidationType.INTERMEDIATE);
        validation1.setComment("Comment 1");
        FormInstanceValidation validation2 = new FormInstanceValidation(request);
        validation2.setValidationBy("31");
        validation2.setDate((Date)Timestamp.valueOf("2020-03-03 15:08:01.07"));
        validation2.setValidationType(FormInstanceValidationType.FINAL);
        validation2.setComment("Comment 2");
        request.getValidations().add(validation1);
        request.getValidations().add(validation2);
        Transaction.performInOne(() -> this.dao.saveRequest(request));
        MatcherAssert.assertThat((Object)this.dao.getAllRequests(formPK), (Matcher)Matchers.hasSize((int)2));
        FormInstance savedRequest = this.dao.getRequest(request.getPK());
        MatcherAssert.assertThat((Object)savedRequest.getId(), (Matcher)Matchers.is((Object)request.getId()));
        MatcherAssert.assertThat((Object)savedRequest.getFormId(), (Matcher)Matchers.is((Object)request.getFormId()));
        MatcherAssert.assertThat((Object)savedRequest.getState(), (Matcher)Matchers.is((Object)request.getState()));
        MatcherAssert.assertThat((Object)savedRequest.getCreatorId(), (Matcher)Matchers.is((Object)request.getCreatorId()));
        MatcherAssert.assertThat((Object)savedRequest.getComponentInstanceId(), (Matcher)Matchers.is((Object)request.getComponentInstanceId()));
        MatcherAssert.assertThat((Object)savedRequest.getCreationDate(), (Matcher)Matchers.greaterThan((Comparable)request.getCreationDate()));
        MatcherAssert.assertThat((Object)savedRequest.getValidations(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testUpdateRequest() throws FormsOnlineException {
        FormPK formPK = new FormPK(1000, "formsOnline100");
        SilverpeasList allRequests = this.dao.getAllRequests(formPK);
        MatcherAssert.assertThat((Object)allRequests, (Matcher)Matchers.hasSize((int)1));
        FormInstance request = (FormInstance)allRequests.iterator().next();
        RequestPK requestPK = request.getPK();
        String creatorIdBeforeSave = request.getCreatorId();
        Date creationDateBeforeSave = request.getCreationDate();
        int stateBeforeUpdate = request.getState();
        request.setCreationDate((Date)Timestamp.from(Instant.now()));
        request.setState(stateBeforeUpdate + 1);
        request.setCreatorId("78");
        Transaction.performInOne(() -> this.dao.saveRequest(request));
        MatcherAssert.assertThat((Object)this.dao.getAllRequests(formPK), (Matcher)Matchers.hasSize((int)1));
        FormInstance savedRequest = this.dao.getRequest(requestPK);
        MatcherAssert.assertThat((Object)savedRequest.getId(), (Matcher)Matchers.is((Object)request.getId()));
        MatcherAssert.assertThat((Object)savedRequest.getFormId(), (Matcher)Matchers.is((Object)request.getFormId()));
        MatcherAssert.assertThat((Object)savedRequest.getState(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)stateBeforeUpdate)));
        MatcherAssert.assertThat((Object)savedRequest.getCreatorId(), (Matcher)Matchers.is((Object)creatorIdBeforeSave));
        MatcherAssert.assertThat((Object)savedRequest.getCreationDate(), (Matcher)Matchers.is((Object)creationDateBeforeSave));
        MatcherAssert.assertThat((Object)savedRequest.getComponentInstanceId(), (Matcher)Matchers.is((Object)request.getComponentInstanceId()));
    }

    @Test
    public void testUpdateRequestValidation() throws FormsOnlineException {
        FormPK formPK = new FormPK(1000, "formsOnline100");
        SilverpeasList allRequests = this.dao.getAllRequests(formPK);
        MatcherAssert.assertThat((Object)allRequests, (Matcher)Matchers.hasSize((int)1));
        FormInstance request = (FormInstance)allRequests.iterator().next();
        FormInstanceValidations requestValidations = request.getValidations();
        MatcherAssert.assertThat((Object)requestValidations, (Matcher)Matchers.hasSize((int)1));
        RequestPK requestPK = request.getPK();
        ((FormInstanceValidation)requestValidations.iterator().next()).setComment("UPDATED COMMENT");
        FormInstanceValidation validation1 = new FormInstanceValidation(request);
        validation1.setValidationBy("31");
        validation1.setValidationType(FormInstanceValidationType.INTERMEDIATE);
        validation1.setComment("INSERTED COMMENT");
        requestValidations.add(validation1);
        Transaction.performInOne(() -> this.dao.saveRequest(request));
        MatcherAssert.assertThat((Object)this.dao.getAllRequests(formPK), (Matcher)Matchers.hasSize((int)1));
        FormInstance savedRequest = this.dao.getRequest(requestPK);
        FormInstanceValidations savedValidations = savedRequest.getValidations();
        MatcherAssert.assertThat((Object)savedValidations, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)savedValidations.stream().map(ContributionValidation::getComment).sorted().collect(Collectors.joining(",")), (Matcher)Matchers.is((Object)"INSERTED COMMENT,UPDATED COMMENT"));
    }

    @Test
    public void testUpdateRequestState() throws FormsOnlineException {
        FormPK formPK = new FormPK(1000, "formsOnline100");
        SilverpeasList allRequests = this.dao.getAllRequests(formPK);
        MatcherAssert.assertThat((Object)allRequests, (Matcher)Matchers.hasSize((int)1));
        FormInstance request = (FormInstance)allRequests.iterator().next();
        RequestPK requestPK = request.getPK();
        int stateBeforeUpdate = request.getState();
        request.setState(stateBeforeUpdate + 1);
        this.dao.saveRequestState(request);
        MatcherAssert.assertThat((Object)this.dao.getAllRequests(formPK), (Matcher)Matchers.hasSize((int)1));
        FormInstance savedRequest = this.dao.getRequest(requestPK);
        MatcherAssert.assertThat((Object)savedRequest.getState(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)stateBeforeUpdate)));
        MatcherAssert.assertThat((Object)savedRequest.getState(), (Matcher)Matchers.is((Object)(stateBeforeUpdate + 1)));
    }

    @Test
    public void testGetReceivedRequests() throws Exception {
        SilverpeasList forms = this.dao.getReceivedRequests(this.dao.getForm(new FormPK(1000, "formsOnline100")), null, null, null);
        MatcherAssert.assertThat((Object)forms, (Matcher)Matchers.hasSize((int)1));
        FormInstance formInstance = (FormInstance)forms.get(0);
        MatcherAssert.assertThat((Object)formInstance.getFormId(), (Matcher)Matchers.is((Object)1000));
        MatcherAssert.assertThat((Object)formInstance.getId(), (Matcher)Matchers.is((Object)"20"));
        MatcherAssert.assertThat((Object)formInstance.getState(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)formInstance.getComments(), (Matcher)Matchers.is((Object)"Salle 18 disponible"));
        MatcherAssert.assertThat((Object)formInstance.getValidatorId(), (Matcher)Matchers.is((Object)"29"));
        MatcherAssert.assertThat((Object)formInstance.getCreationDate(), (Matcher)Matchers.is((Object)Timestamp.valueOf("2012-01-28 10:50:34.26")));
        MatcherAssert.assertThat((Object)formInstance.getValidationDate(), (Matcher)Matchers.is((Object)Timestamp.valueOf("2012-01-29 11:03:38.07")));
        MatcherAssert.assertThat((Object)formInstance.getValidations(), (Matcher)Matchers.hasSize((int)1));
        FormInstanceValidation validation = (FormInstanceValidation)formInstance.getValidations().iterator().next();
        MatcherAssert.assertThat((Object)validation.getId(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)validation.getFormInstance().getId(), (Matcher)Matchers.is((Object)formInstance.getId()));
        MatcherAssert.assertThat((Object)validation.getValidator().getId(), (Matcher)Matchers.is((Object)"29"));
        MatcherAssert.assertThat((Object)validation.getValidationType(), (Matcher)Matchers.is((Object)FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)validation.getStatus(), (Matcher)Matchers.is((Object)ContributionStatus.VALIDATED));
        MatcherAssert.assertThat((Object)validation.isFollower(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)validation.getDate(), (Matcher)Matchers.is((Object)Timestamp.valueOf("2012-01-29 11:03:38.07")));
        MatcherAssert.assertThat((Object)validation.getComment(), (Matcher)Matchers.is((Object)"Salle 18 disponible"));
    }

    @Test
    public void testGetRequestsByCriteriaWithoutComponentInstanceCriteria() throws Exception {
        SilverpeasList requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[0]).andCreatorId("1"));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.empty());
    }

    @Test
    public void testGetRequestsIntoContextOfValidator() throws Exception {
        this.createDefaultDynamicContextOfData(1, DEFAULT_VALIDATION_CYCLE.length);
        Set senderIds = CollectionUtil.asSet((Object[])new String[]{"1", "67"});
        SilverpeasList requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"29", null)));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 12, 10, 9, 8, 7, 6, 5, 4, 3, 2);
        MatcherAssert.assertThat((Object)((FormInstance)requests.iterator().next()).getValidations(), (Matcher)Matchers.hasSize((int)3));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"29", null).orNoValidator()));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 12, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1);
        MatcherAssert.assertThat((Object)((FormInstance)requests.iterator().next()).getValidations(), (Matcher)Matchers.hasSize((int)3));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"29", (MemoizedSupplier)new MemoizedSupplier(() -> senderIds)).orValidatorIsHierarchicalOne()));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 12, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1);
        MatcherAssert.assertThat((Object)((FormInstance)requests.iterator().next()).getValidations(), (Matcher)Matchers.hasSize((int)3));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"29", null).andAvoidValidatedByValidator()));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.empty());
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"29", null).andAvoidValidatedByValidator().orLastValidationType(new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL})));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 2);
        RequestValidationCriteria validationCriteria = RequestValidationCriteria.withValidatorId((String)"29", null).andAvoidValidatedByValidator().orLastValidationType(new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL});
        validationCriteria.skipValidationFiltering();
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(validationCriteria));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"29", null).invert().andAvoidValidatedByValidator().orLastValidationType(new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL})));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 1);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"29", null).andStillNeedValidation().orLastValidationType(new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL})));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 2);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null)));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 12, 11, 9, 8);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null).orLastValidationType(new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL})));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 12, 11, 9, 8, 2);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null).andAvoidValidatedByValidator()));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.empty());
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null).andAvoidValidatedByValidator().orLastValidationType(new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL})));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 2);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null).andStillNeedValidation().orLastValidationType(new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL})));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.empty());
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null).andStillNeedValidation()));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.empty());
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null).orLastValidationType(new FormInstanceValidationType[]{FormInstanceValidationType.INTERMEDIATE})));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 12, 11, 9, 8, 3);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null).orLastValidationType(new FormInstanceValidationType[]{FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.HIERARCHICAL})));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 12, 11, 9, 8, 3, 2);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null).orLastValidationType(new FormInstanceValidationType[]{FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.HIERARCHICAL}).andAvoidValidatedByValidator()));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 8, 3, 2);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null).orLastValidationType(new FormInstanceValidationType[]{FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.HIERARCHICAL}).andStillNeedValidation()));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 8);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null).orNoValidator()));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 12, 11, 9, 8, 1);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", (MemoizedSupplier)new MemoizedSupplier(() -> senderIds)).orValidatorIsHierarchicalOne()));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 12, 11, 9, 8, 1);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"69", null)));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.empty());
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"69", null).orNoValidator()));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 1);
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"69", (MemoizedSupplier)new MemoizedSupplier(() -> senderIds)).orValidatorIsHierarchicalOne()));
        this.assertContainsIdsWithOffsetAutomaticallyApplied((List<FormInstance>)requests, 1);
    }

    @Test
    public void testGetRequestsByValidator() throws Exception {
        this.createDefaultDynamicContextOfData(1, DEFAULT_VALIDATION_CYCLE.length);
        SilverpeasList requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"29", null)));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)(DEFAULT_VALIDATION_CYCLE.length - 2)));
        MatcherAssert.assertThat((Object)((FormInstance)requests.iterator().next()).getValidations(), (Matcher)Matchers.hasSize((int)3));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"30", null)));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)4));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andValidationCriteria(RequestValidationCriteria.withValidatorId((String)"69", null)));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.empty());
    }

    @Test
    public void testGetRequestsByIdCriteria() throws Exception {
        this.createDefaultDynamicContextOfData(1, DEFAULT_VALIDATION_CYCLE.length);
        SilverpeasList requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andIds(new String[]{"100008"}));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((FormInstance)requests.iterator().next()).getValidations(), (Matcher)Matchers.hasSize((int)2));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andIds(new String[]{"100008", "100012"}));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((FormInstance)requests.iterator().next()).getValidations(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void testGetRequestsByFormIdCriteria() throws Exception {
        this.createDefaultDynamicContextOfData(3, DEFAULT_VALIDATION_CYCLE.length * 10);
        SilverpeasList requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andFormIds(new String[]{"100001"}));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)(DEFAULT_VALIDATION_CYCLE.length * 10)));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andFormIds(new String[]{"100001", "100003"}));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)(DEFAULT_VALIDATION_CYCLE.length * 20)));
    }

    @Test
    public void testGetRequestsByCreatorIdCriteria() throws Exception {
        int nbRequestsPerForm = DEFAULT_VALIDATION_CYCLE.length * 10;
        this.createDefaultDynamicContextOfData(1, nbRequestsPerForm);
        SilverpeasList requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andCreatorId(DEFAULT_CREATOR_IDS[0]));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)(nbRequestsPerForm / 2)));
        FormInstance request1 = (FormInstance)requests.iterator().next();
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andCreatorId(DEFAULT_CREATOR_IDS[1]));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)(nbRequestsPerForm / 2)));
        MatcherAssert.assertThat((Object)((FormInstance)requests.iterator().next()).getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)request1.getId())));
    }

    @Test
    public void testGetRequestsByStateCriteria() throws Exception {
        int nbRequestsPerForm = DEFAULT_VALIDATION_CYCLE.length * 10;
        this.createDefaultDynamicContextOfData(1, nbRequestsPerForm);
        SilverpeasList requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andStates(new Integer[]{DEFAULT_FORM_STATES[0]}));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)(nbRequestsPerForm / 2)));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andStates(new Integer[]{DEFAULT_FORM_STATES[1]}));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)(nbRequestsPerForm / 2)));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).andStates(new Integer[]{DEFAULT_FORM_STATES[1], DEFAULT_FORM_STATES[0]}));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)nbRequestsPerForm));
    }

    @Test
    public void testGetRequestsByCriteriaIntoHugeContextOfData() throws Exception {
        List<String> requestIds = this.createDefaultDynamicContextOfData(10, 1000);
        SilverpeasList requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26", "formsOnline100"}));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)(requestIds.size() + 2)));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)requestIds.size()));
        FormInstance request = (FormInstance)requests.get(0);
        MatcherAssert.assertThat((Object)request.getIdAsInt(), (Matcher)Matchers.is((Object)(100000 + requestIds.size())));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).paginateBy(new PaginationPage(2, 10)));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)10));
        MatcherAssert.assertThat((Object)requests.originalListSize(), (Matcher)Matchers.is((Object)requestIds.size()));
        request = (FormInstance)requests.get(0);
        MatcherAssert.assertThat((Object)request.getIdAsInt(), (Matcher)Matchers.is((Object)(100000 + requestIds.size() - 10)));
        requests = this.dao.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds((String[])new String[]{"formsOnline26"}).orderBy(new RequestCriteria.QUERY_ORDER_BY[]{RequestCriteria.QUERY_ORDER_BY.CREATION_DATE_ASC, RequestCriteria.QUERY_ORDER_BY.ID_ASC}));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasSize((int)requestIds.size()));
        request = (FormInstance)requests.get(0);
        MatcherAssert.assertThat((Object)request.getIdAsInt(), (Matcher)Matchers.is((Object)100001));
        for (int i = 0; i < DEFAULT_VALIDATION_CYCLE.length; ++i) {
            request = (FormInstance)requests.get(i);
            ArrayList<String> expectedList = new ArrayList<String>();
            Object[][] expectedValidations = (Object[][])DEFAULT_VALIDATION_CYCLE[i];
            if (expectedValidations != null) {
                for (Object[] expectedValidation : expectedValidations) {
                    expectedList.add(Stream.of(expectedValidation).map(Object::toString).collect(Collectors.joining(",")));
                }
            }
            FormInstanceValidations actualValidations = request.getValidations();
            MatcherAssert.assertThat((Object)actualValidations, (Matcher)Matchers.hasSize((int)expectedList.size()));
            if (actualValidations.isEmpty()) continue;
            List actualList = actualValidations.stream().map(v -> String.format("%s,%s,%s,%s,%s,%s", v.getValidator().getId(), v.getValidationType(), v.getStatus(), v.isFollower(), v.getDate(), v.getComment())).collect(Collectors.toList());
            MatcherAssert.assertThat(actualList, (Matcher)Matchers.containsInAnyOrder((Object[])expectedList.toArray()));
        }
    }
}

