/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.components.forums.model.ForumDetail;
import org.silverpeas.components.forums.model.ForumPK;
import org.silverpeas.components.forums.service.ForumsServiceProvider;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractSilverpeasContentManager;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.contribution.model.Contribution;

@Service
public class ForumsContentManager
extends AbstractSilverpeasContentManager {
    private static final String CONTENT_ICON_FILE_NAME = "forumsSmall.gif";

    protected ForumsContentManager() {
    }

    protected String getContentIconFileName(String componentInstanceId) {
        return CONTENT_ICON_FILE_NAME;
    }

    protected Optional<Contribution> getContribution(String resourceId, String componentInstanceId) {
        ForumDetail forumDetail = ForumsServiceProvider.getForumsService().getForumDetail(new ForumPK(componentInstanceId, resourceId));
        return Optional.ofNullable(forumDetail);
    }

    protected List<Contribution> getAccessibleContributions(List<ResourceReference> resourceReferences, String currentUserId) {
        List<ForumPK> ids = resourceReferences.stream().map(r -> new ForumPK(r.getComponentInstanceId(), r.getLocalId())).collect(Collectors.toList());
        return new ArrayList<ForumDetail>(ForumsServiceProvider.getForumsService().getForums(ids));
    }

    protected <T extends Contribution> SilverContentVisibility computeSilverContentVisibility(T contribution) {
        return new SilverContentVisibility(true);
    }

    public int createSilverContent(Connection con, ForumPK forumPK, String userId) throws ContentManagerException {
        return this.createSilverContent(con, forumPK.getId(), forumPK.getComponentName(), userId);
    }

    public void deleteSilverContent(Connection con, ForumPK forumPK) throws ContentManagerException {
        this.deleteSilverContent(con, forumPK.getId(), forumPK.getComponentName());
    }
}

