/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.comment.service;

import java.util.Collection;
import java.util.Set;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.comment.service.CommentService;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.SilverpeasToolContent;
import org.silverpeas.core.notification.user.FallbackToCoreTemplatePathBehavior;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.StringUtil;

public class CommentUserNotification
extends AbstractTemplateUserNotificationBuilder<Contribution>
implements FallbackToCoreTemplatePathBehavior {
    public static final String NOTIFICATION_COMMENT_ATTRIBUTE = "comment";
    private static final String TEMPLATE_PATH = "comment";
    private static final String DEFAULT_SUBJECT_COMMENT_ADDING = "comments.commentAddingSubject";
    private static final String NOTIFICATION_CONTENT_ATTRIBUTE = "content";
    private final CommentService commentService;
    private final String subjectKey;
    private final LocalizationBundle componentMessages;
    private final Comment comment;
    private final Set<String> recipients;

    public CommentUserNotification(CommentService commentService, Comment comment, Contribution commentedContent, String subjectKey, LocalizationBundle componentMessages, Set<String> recipients) {
        super((Object)commentedContent);
        this.commentService = commentService;
        this.comment = comment;
        this.subjectKey = subjectKey;
        this.componentMessages = componentMessages;
        this.recipients = recipients;
    }

    protected String getBundleSubjectKey() {
        return this.subjectKey;
    }

    protected String getTitle(String language) {
        String subject = this.componentMessages.containsKey(this.getBundleSubjectKey()) ? this.componentMessages.getString(this.getBundleSubjectKey()) : "";
        return StringUtil.isDefined((String)subject) ? subject : this.commentService.getComponentMessages(this.componentMessages.getLocale().getLanguage()).getString(DEFAULT_SUBJECT_COMMENT_ADDING);
    }

    protected Collection<String> getUserIdsToNotify() {
        return this.recipients;
    }

    protected void perform(Contribution resource) {
        this.getNotificationMetaData().setOriginalExtraMessage(this.comment.getMessage());
    }

    protected void performTemplateData(String language, Contribution resource, SilverpeasTemplate template) {
        this.componentMessages.changeLocale(language);
        this.getNotificationMetaData().addLanguage(language, this.getTitle(), "");
        template.setAttribute(NOTIFICATION_CONTENT_ATTRIBUTE, this.getResource());
        template.setAttribute("comment", (Object)this.comment);
    }

    protected void performNotificationResource(String language, Contribution resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getTitle());
        notificationResourceData.setResourceDescription(resource.getDescription());
    }

    protected String getTemplatePath() {
        return "comment";
    }

    protected String getTemplateFileName() {
        return "commented";
    }

    protected NotifAction getAction() {
        return NotifAction.COMMENT;
    }

    protected String getComponentInstanceId() {
        return this.comment.getIdentifier().getComponentInstanceId();
    }

    protected String getSender() {
        return this.comment.getCreator().getId();
    }

    protected boolean isSendImmediately() {
        return this.getResource() instanceof SilverpeasToolContent;
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.util.comment.multilang.comment";
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "comment.notifCommentLinkLabel";
    }
}

