/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.comment.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.annotation.Technical;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.comment.model.CommentId;
import org.silverpeas.core.comment.model.CommentedPublicationInfo;
import org.silverpeas.core.comment.socialnetwork.SocialInformationComment;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;

@Technical
@Bean
public class JDBCCommentRequester {
    private static final int INITIAL_CAPACITY = 1000;
    private static final String COMMENT_TABLE = "sb_comment_comment";
    private static final String COMMENT_ID = "commentId";
    private static final String INSTANCE_ID = "instanceId";
    private static final String RESOURCE_ID = "resourceId";
    private static final String COMMENT_MODIFICATION_DATE = "commentModificationDate";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String COMMENT_OWNER_ID = "commentOwnerId";
    private static final String COMMENT_TEXT = "commentComment";
    private static final String COMMENT_CREATION_DATE = "commentCreationDate";
    private static final String COMMENT_COUNT = "nb_comment";
    private static final String SQL_COMMENT_QUERY = "SELECT commentId, commentOwnerId, commentCreationDate, commentModificationDate, commentComment, resourceType, resourceId, instanceId FROM sb_comment_comment";
    private static final String SELECT_COMMENT_COUNT = "SELECT COUNT(commentId) as nb_comment, resourceType, resourceId, instanceId FROM sb_comment_comment";

    protected JDBCCommentRequester() {
    }

    public Comment saveComment(Connection con, Comment cmt) throws SQLException {
        String insertQuery = "INSERT INTO sb_comment_comment (commentId , commentOwnerId, commentCreationDate, commentModificationDate, commentComment, resourceType, resourceId, instanceId) VALUES ( ?, ?, ?, ?, ?, ?, ?, ? )";
        int newId = DBUtil.getNextId((String)COMMENT_TABLE, (String)COMMENT_ID);
        try (PreparedStatement prepStmt = con.prepareStatement(insertQuery);){
            prepStmt.setInt(1, newId);
            prepStmt.setInt(2, Integer.parseInt(cmt.getCreatorId()));
            prepStmt.setString(3, DateUtil.date2SQLDate((Date)cmt.getCreationDate()));
            String updateDate = cmt.getLastUpdateDate() != null ? DateUtil.date2SQLDate((Date)cmt.getLastUpdateDate()) : null;
            prepStmt.setString(4, updateDate);
            prepStmt.setString(5, cmt.getMessage());
            prepStmt.setString(6, cmt.getResourceType());
            prepStmt.setString(7, cmt.getResourceReference().getLocalId());
            prepStmt.setString(8, cmt.getIdentifier().getComponentInstanceId());
            prepStmt.executeUpdate();
        }
        CommentId id = new CommentId(cmt.getIdentifier().getComponentInstanceId(), String.valueOf(newId));
        return this.getComment(con, id);
    }

    public void deleteComment(Connection con, CommentId id) throws SQLException {
        String deleteQuery = "DELETE FROM sb_comment_comment WHERE commentId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(deleteQuery);){
            prepStmt.setInt(1, Integer.parseInt(id.getLocalId()));
            prepStmt.executeUpdate();
        }
    }

    public void updateComment(Connection con, Comment cmt) throws SQLException {
        String updateQuery = "UPDATE sb_comment_comment SET commentOwnerId=?, commentModificationDate=?, commentComment=?, resourceType=?, resourceId=?, instanceId=? WHERE commentId= ?";
        try (PreparedStatement prepStmt = con.prepareStatement(updateQuery);){
            prepStmt.setInt(1, Integer.parseInt(cmt.getCreatorId()));
            prepStmt.setString(2, DateUtil.date2SQLDate((Date)cmt.getLastUpdateDate()));
            prepStmt.setString(3, cmt.getMessage());
            prepStmt.setString(4, cmt.getResourceType());
            prepStmt.setString(5, cmt.getResourceReference().getLocalId());
            prepStmt.setString(6, cmt.getIdentifier().getComponentInstanceId());
            prepStmt.setInt(7, Integer.parseInt(cmt.getIdentifier().getLocalId()));
            prepStmt.executeUpdate();
        }
    }

    public void moveComments(Connection con, String fromResourceType, ResourceReference fromResource, String toResourceType, ResourceReference toResource) throws SQLException {
        String updateQuery = "UPDATE sb_comment_comment SET resourceType=?, resourceId=?, instanceId=? WHERE resourceType=? AND resourceId=? AND instanceId=?";
        try (PreparedStatement prepStmt = con.prepareStatement(updateQuery);){
            prepStmt.setString(1, toResourceType);
            prepStmt.setString(2, toResource.getLocalId());
            prepStmt.setString(3, toResource.getComponentInstanceId());
            prepStmt.setString(4, fromResourceType);
            prepStmt.setString(5, fromResource.getLocalId());
            prepStmt.setString(6, fromResource.getComponentInstanceId());
            prepStmt.executeUpdate();
        }
    }

    public Comment getComment(Connection con, CommentId commentId) throws SQLException {
        String selectQuery = "SELECT commentId, commentOwnerId, commentCreationDate, commentModificationDate, commentComment, resourceType, resourceId, instanceId FROM sb_comment_comment WHERE commentId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(selectQuery);){
            Comment comment;
            block16: {
                ResultSet rs;
                block14: {
                    Comment comment2;
                    block15: {
                        prepStmt.setInt(1, Integer.parseInt(commentId.getLocalId()));
                        rs = prepStmt.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            comment2 = this.toComment(rs);
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return comment2;
                }
                comment = null;
                if (rs == null) break block16;
                rs.close();
            }
            return comment;
        }
    }

    public List<CommentedPublicationInfo> getMostCommentedAllPublications(Connection con, String resType) throws SQLException {
        if (StringUtil.isDefined((String)resType)) {
            String selectQuery = "SELECT COUNT(commentId) as nb_comment, resourceType, resourceId, instanceId FROM sb_comment_comment WHERE resourceType = ? GROUP BY resourceType, resourceId, instanceId ORDER BY nb_comment desc;";
            try (PreparedStatement stmt = con.prepareStatement(selectQuery);){
                List<CommentedPublicationInfo> list;
                block25: {
                    stmt.setString(1, resType);
                    ResultSet rs = stmt.executeQuery();
                    try {
                        list = this.fetchCommentedPublicationInfos(rs);
                        if (rs == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return list;
            }
        }
        String selectQuery = "SELECT COUNT(commentId) as nb_comment, resourceType, resourceId, instanceId FROM sb_comment_comment GROUP BY resourceType, resourceId, instanceId ORDER BY nb_comment desc;";
        try (Statement prepStmt = con.createStatement();){
            List<CommentedPublicationInfo> list;
            block26: {
                ResultSet rs = prepStmt.executeQuery(selectQuery);
                try {
                    list = this.fetchCommentedPublicationInfos(rs);
                    if (rs == null) break block26;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    public List<CommentedPublicationInfo> getMostCommentedPublications(Connection con, List<ResourceReference> pubRefs) throws SQLException {
        Object query = SELECT_COMMENT_COUNT;
        ArrayList<String> resourceIds = new ArrayList<String>(pubRefs.size());
        ArrayList<String> instanceIds = new ArrayList<String>(pubRefs.size());
        for (ResourceReference ref : pubRefs) {
            if (JDBCCommentRequester.isIdDefined(ref.getLocalId())) {
                resourceIds.add(ref.getLocalId());
            }
            if (!JDBCCommentRequester.isIdDefined(ref.getComponentInstanceId())) continue;
            instanceIds.add(ref.getComponentInstanceId());
        }
        if (!resourceIds.isEmpty()) {
            query = (String)query + " where resourceId in (?)";
        }
        if (!instanceIds.isEmpty()) {
            query = (String)query + (((String)query).contains("where") ? " and " : " where ") + "instanceId in (?)";
        }
        query = (String)query + " GROUP BY resourceType, resourceId, instanceId ORDER BY nb_comment desc";
        try (PreparedStatement stmt = con.prepareStatement((String)query);){
            List<CommentedPublicationInfo> list;
            block18: {
                int i = 1;
                if (!resourceIds.isEmpty()) {
                    stmt.setString(i++, StringUtils.join(resourceIds, (String)","));
                }
                if (!instanceIds.isEmpty()) {
                    stmt.setString(i, StringUtils.join(instanceIds, (String)","));
                }
                ResultSet rs = stmt.executeQuery();
                try {
                    list = this.fetchCommentedPublicationInfos(rs);
                    if (rs == null) break block18;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    public int getCommentsCount(Connection con, String resourceType, ResourceReference resourceRef) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder selectQuery = new StringBuilder("SELECT COUNT(commentId) AS nb_comment FROM sb_comment_comment");
        this.performQueryAndParams(selectQuery, params, resourceType, resourceRef);
        int commentsCount = 0;
        try (PreparedStatement prepStmt = con.prepareStatement(selectQuery.toString());){
            int indexParam = 1;
            for (Object e : params) {
                prepStmt.setString(indexParam++, (String)e);
            }
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    commentsCount = rs.getInt(COMMENT_COUNT);
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return commentsCount;
    }

    public List<Comment> getAllComments(Connection con, String resourceType, ResourceReference resourceRef) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder selectQuery = new StringBuilder();
        selectQuery.append(SQL_COMMENT_QUERY);
        this.performQueryAndParams(selectQuery, params, resourceType, resourceRef);
        selectQuery.append("ORDER BY commentCreationDate DESC, commentId DESC");
        ArrayList<Comment> comments = new ArrayList<Comment>(1000);
        try (PreparedStatement prepStmt = con.prepareStatement(selectQuery.toString());){
            int indexParam = 1;
            for (Object e : params) {
                prepStmt.setString(indexParam++, (String)e);
            }
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    Comment comment = this.toComment(rs);
                    comments.add(comment);
                }
            }
        }
        return comments;
    }

    public int deleteAllComments(Connection con, String resourceType, ResourceReference resourceReference) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder deleteQuery = new StringBuilder("DELETE FROM sb_comment_comment");
        this.performQueryAndParams(deleteQuery, params, resourceType, resourceReference);
        try (PreparedStatement prepStmt = con.prepareStatement(deleteQuery.toString());){
            int indexParam = 1;
            for (Object e : params) {
                prepStmt.setString(indexParam++, (String)e);
            }
            int n = prepStmt.executeUpdate();
            return n;
        }
    }

    private void performQueryAndParams(StringBuilder query, List<Object> params, String resourceType, ResourceReference resourceRef) {
        ArrayList<String> listResourceType = new ArrayList<String>();
        if (StringUtil.isDefined((String)resourceType)) {
            listResourceType.add(resourceType);
        }
        this.performQueryAndParams(query, params, listResourceType, resourceRef, null, null, null);
    }

    private void performQueryAndParams(StringBuilder query, List<Object> params, List<String> listResourceType, ResourceReference resourceRef, List<String> listUserId, List<String> listInstanceId, Period period) {
        String clause = " WHERE ";
        if (CollectionUtil.isNotEmpty(listResourceType)) {
            this.appendInList(query, params, clause, RESOURCE_TYPE, listResourceType);
            clause = "AND ";
        }
        if (resourceRef != null) {
            if (JDBCCommentRequester.isIdDefined(resourceRef.getLocalId())) {
                query.append(clause).append("resourceId = ? ");
                clause = "AND ";
                params.add(resourceRef.getLocalId());
            }
            if (JDBCCommentRequester.isIdDefined(resourceRef.getComponentInstanceId())) {
                query.append(clause).append("instanceId = ? ");
                clause = "AND ";
                params.add(resourceRef.getComponentInstanceId());
            }
        }
        if (CollectionUtil.isNotEmpty(listUserId)) {
            Set listUserIdsAsInt = listUserId.stream().map(Integer::parseInt).collect(Collectors.toSet());
            this.appendInList(query, params, clause, COMMENT_OWNER_ID, listUserIdsAsInt);
            clause = "AND ";
        }
        if (listInstanceId != null) {
            if (listInstanceId.isEmpty()) {
                query.append(clause).append("instanceId IN ('noComponentInstanceId') ");
            } else {
                this.appendInList(query, params, clause, INSTANCE_ID, listInstanceId);
            }
            clause = "AND ";
        }
        if (period != null) {
            query.append(clause).append("((commentModificationDate BETWEEN ? AND ?) ");
            params.add(DateUtil.temporal2SQLDate((Temporal)period.getStartDate()));
            params.add(DateUtil.temporal2SQLDate((Temporal)period.getEndDate()));
            query.append("OR (commentCreationDate BETWEEN ? AND ?)) ");
            params.add(DateUtil.temporal2SQLDate((Temporal)period.getStartDate()));
            params.add(DateUtil.temporal2SQLDate((Temporal)period.getEndDate()));
        }
        if (params.isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    private <T> void appendInList(StringBuilder query, List<Object> params, String clause, String listName, Collection<T> values) {
        query.append(clause).append(listName).append(" IN (");
        String sep = "";
        for (T value : values) {
            query.append(sep).append("?");
            sep = ", ";
            params.add(value);
        }
        query.append(") ");
    }

    public List<Comment> getLastComments(Connection con, String instanceId, int count) throws SQLException {
        String query = "SELECT commentId, commentOwnerId, commentCreationDate, commentModificationDate, commentComment, resourceType, resourceId, instanceId FROM sb_comment_comment WHERE instanceId = ? ORDER BY commentCreationDate DESC, commentId DESC";
        ArrayList<Comment> comments = new ArrayList<Comment>(count);
        try (PreparedStatement stmt = con.prepareStatement(query);){
            stmt.setString(1, instanceId);
            if (count > 0) {
                stmt.setMaxRows(count);
            }
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    Comment comment = this.toComment(rs);
                    comments.add(comment);
                }
            }
        }
        return comments;
    }

    public List<SocialInformationComment> getSocialInformationComments(Connection con, List<String> resourceTypes, List<String> userAuthorIds, List<String> instanceIds, Period period) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder selectQuery = new StringBuilder();
        selectQuery.append(SQL_COMMENT_QUERY);
        this.performQueryAndParams(selectQuery, params, resourceTypes, null, userAuthorIds, instanceIds, period);
        selectQuery.append("ORDER BY commentModificationDate DESC, commentId DESC");
        ArrayList<SocialInformationComment> listSocialInformationComment = new ArrayList<SocialInformationComment>(1000);
        try (PreparedStatement prepStmt = con.prepareStatement(selectQuery.toString());){
            int indexParam = 1;
            for (Object e : params) {
                if (e instanceof String) {
                    prepStmt.setString(indexParam++, (String)e);
                    continue;
                }
                if (!(e instanceof Integer)) continue;
                prepStmt.setInt(indexParam++, (Integer)e);
            }
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    Comment comment = this.toComment(rs);
                    listSocialInformationComment.add(new SocialInformationComment(comment));
                }
            }
        }
        return listSocialInformationComment;
    }

    private List<CommentedPublicationInfo> fetchCommentedPublicationInfos(ResultSet rs) throws SQLException {
        ArrayList<CommentedPublicationInfo> listPublisCommentsCount = new ArrayList<CommentedPublicationInfo>();
        while (rs.next()) {
            int countComment = rs.getInt(COMMENT_COUNT);
            String resourceType = rs.getString(RESOURCE_TYPE);
            String resourceId = rs.getString(RESOURCE_ID);
            String instanceId = rs.getString(INSTANCE_ID);
            listPublisCommentsCount.add(new CommentedPublicationInfo(resourceType, resourceId, instanceId, countComment));
        }
        return listPublisCommentsCount;
    }

    private Comment toComment(ResultSet rs) throws SQLException {
        String instanceId = rs.getString(INSTANCE_ID);
        CommentId id = new CommentId(instanceId, String.valueOf(rs.getInt(COMMENT_ID)));
        ResourceReference resourceId = new ResourceReference(rs.getString(RESOURCE_ID), instanceId);
        String resourceType = rs.getString(RESOURCE_TYPE);
        String creatorId = String.valueOf(rs.getInt(COMMENT_OWNER_ID));
        String text = rs.getString(COMMENT_TEXT);
        try {
            Date creationDate = DateUtil.parseDate((String)rs.getString(COMMENT_CREATION_DATE));
            Date updateDate = DateUtil.parseDate((String)rs.getString(COMMENT_MODIFICATION_DATE));
            Comment comment = new Comment(id, creatorId, resourceType, resourceId, creationDate);
            comment.setLastUpdateDate(updateDate);
            comment.setMessage(text);
            return comment;
        }
        catch (ParseException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    private static boolean isIdDefined(String id) {
        return StringUtil.isDefined((String)id) && !"".equals(id);
    }
}

