/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public final class LimitTokenOffsetFilter
extends TokenFilter {
    private final OffsetAttribute offsetAttrib = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private int maxStartOffset;
    private final boolean consumeAllTokens;

    public LimitTokenOffsetFilter(TokenStream input, int maxStartOffset) {
        this(input, maxStartOffset, false);
    }

    public LimitTokenOffsetFilter(TokenStream input, int maxStartOffset, boolean consumeAllTokens) {
        super(input);
        if (maxStartOffset < 0) {
            throw new IllegalArgumentException("maxStartOffset must be >= zero");
        }
        this.maxStartOffset = maxStartOffset;
        this.consumeAllTokens = consumeAllTokens;
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.offsetAttrib.startOffset() <= this.maxStartOffset) {
            return true;
        }
        if (this.consumeAllTokens) {
            while (this.input.incrementToken()) {
            }
        }
        return false;
    }
}

