/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.websites;

import java.io.File;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.websites.dao.SiteDAO;
import org.silverpeas.core.admin.component.ComponentInstancePreDestruction;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;
import org.silverpeas.core.util.file.FileFolderManager;

@Named
public class WebSitesInstancePreDestruction
implements ComponentInstancePreDestruction {
    @Transactional
    public void preDestroy(String componentInstanceId) {
        try {
            SiteDAO siteDAO = new SiteDAO(componentInstanceId);
            siteDAO.deleteAllWebSites();
            this.deleteAttachmentsAndImagesDirectory(componentInstanceId);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void deleteAttachmentsAndImagesDirectory(String componentId) throws Exception {
        SettingBundle uploadSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.webSites.settings.webSiteSettings");
        FileFolderManager.deleteFolder((String)(uploadSettings.getString("uploadsPath") + File.separator + componentId));
    }
}

