/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.survey.notification;

import javax.inject.Named;
import org.silverpeas.components.survey.notification.SurveyUserAlertNotification;
import org.silverpeas.core.SilverpeasRuntimeException;
import org.silverpeas.core.notification.user.AbstractComponentInstanceManualUserNotification;
import org.silverpeas.core.notification.user.NotificationContext;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerDetail;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerPK;
import org.silverpeas.core.questioncontainer.container.service.QuestionContainerService;

@Named
public class SurveyInstanceManualUserNotification
extends AbstractComponentInstanceManualUserNotification {
    private static final String QUESTION_CONTAINER_DETAIL_KEY = "QuestionContainerDetailKey";

    protected boolean check(NotificationContext context) {
        QuestionContainerDetail questionDetail = this.getSurvey(context);
        context.put((Object)QUESTION_CONTAINER_DETAIL_KEY, (Object)questionDetail);
        return questionDetail.canBeAccessedBy(context.getSender());
    }

    public UserNotification createUserNotification(NotificationContext context) {
        QuestionContainerDetail questionDetail = (QuestionContainerDetail)context.getObject((Object)QUESTION_CONTAINER_DETAIL_KEY);
        return new SurveyUserAlertNotification(questionDetail, context.getSender()).build();
    }

    private QuestionContainerDetail getSurvey(NotificationContext context) {
        try {
            String componentId = context.getComponentId();
            String surveyId = context.getContributionId();
            QuestionContainerPK qcPK = new QuestionContainerPK(surveyId, "", componentId);
            return QuestionContainerService.get().getQuestionContainer(qcPK, context.getSender().getId());
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }
}

