/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.http;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.SilverpeasRuntimeException;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheServiceProvider;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.upload.FileUploadManager;
import org.silverpeas.core.io.upload.UploadedFile;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.core.util.logging.SilverLogger;
import org.silverpeas.core.web.http.RequestFile;
import org.silverpeas.core.web.http.RequestParameterDecoder;

public class HttpRequest
extends HttpServletRequestWrapper {
    private static final String SECURE_PROPERTY = "secure";
    private List<FileItem> fileItems = null;

    private HttpRequest(HttpServletRequest request) {
        super(request);
        request.setAttribute(HttpRequest.class.getName(), (Object)this);
    }

    public static HttpRequest decorate(HttpServletRequest request) {
        CacheServiceProvider.getRequestCacheService().getCache().put((Object)SECURE_PROPERTY, (Object)request.isSecure());
        return request instanceof HttpRequest ? (HttpRequest)request : new HttpRequest(request);
    }

    public static HttpRequest decorate(ServletRequest request) {
        return HttpRequest.decorate((HttpServletRequest)request);
    }

    public static boolean isCurrentRequestSecure() {
        Boolean secure = (Boolean)CacheServiceProvider.getRequestCacheService().getCache().get((Object)SECURE_PROPERTY, Boolean.class);
        if (secure == null) {
            throw new IllegalStateException("The current execution context isn't relative to an incoming HTTP request");
        }
        return secure;
    }

    public boolean isWithinAnonymousUserSession() {
        User user = User.getCurrentRequester();
        return user != null && user.isAnonymous();
    }

    public boolean isWithinUserSession() {
        return User.getCurrentRequester() != null;
    }

    public List<FileItem> getFileItems() {
        if (this.fileItems == null) {
            this.fileItems = FileUploadUtil.parseRequest((HttpServletRequest)this);
        }
        return this.fileItems;
    }

    public FileItem getFileItem(String name) {
        FileItem item = null;
        List<FileItem> items = this.getFileItems();
        for (FileItem fileItem : items) {
            if (!fileItem.getFieldName().equals(name)) continue;
            item = fileItem;
            break;
        }
        return item;
    }

    public FileItem getFile(String name) {
        return FileUploadUtil.getFile(this.getFileItems(), (String)name);
    }

    public FileItem getSingleFile() {
        return FileUploadUtil.getFile(this.getFileItems());
    }

    public boolean hasCookie(String name) {
        if (StringUtil.isNotDefined((String)name)) {
            return false;
        }
        boolean found = false;
        Cookie[] cookies = this.getCookies();
        for (int i = 0; i < cookies.length && !found; ++i) {
            found = cookies[i].getName().equals(name);
        }
        return found;
    }

    public String getUserLanguage() {
        String language = I18NHelper.DEFAULT_LANGUAGE;
        User user = User.getCurrentRequester();
        if (user != null) {
            language = user.getUserPreferences().getLanguage();
        }
        return language;
    }

    public Collection<UploadedFile> getUploadedFiles() {
        List<Object> uploadedFiles = new ArrayList<UploadedFile>();
        User user = User.getCurrentRequester();
        if (user != null) {
            uploadedFiles = FileUploadManager.getUploadedFiles((HttpServletRequest)this, (User)user);
        }
        return uploadedFiles;
    }

    public boolean getAttributeAsBoolean(String attributeName) {
        return RequestParameterDecoder.asBoolean(this.getAttribute(attributeName));
    }

    public Long getAttributeAsLong(String attributeName) {
        return RequestParameterDecoder.asLong(this.getAttribute(attributeName));
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null && this.isContentInMultipart() && this.isNotSOAPRequest() && this.isNotCmis()) {
            List listOfValues = FileUploadUtil.getParameterValues(this.getFileItems(), (String)name, (String)this.getCharacterEncoding());
            values = listOfValues.toArray(new String[0]);
        }
        return values;
    }

    public Enumeration<String> getParameterNames() {
        Enumeration names = super.getParameterNames();
        if (!names.hasMoreElements() && this.isContentInMultipart() && this.isNotSOAPRequest() && this.isNotCmis()) {
            List<FileItem> items = this.getFileItems();
            ArrayList<String> itemNames = new ArrayList<String>(items.size());
            for (FileItem item : items) {
                if (!item.isFormField()) continue;
                itemNames.add(item.getFieldName());
            }
            names = Collections.enumeration(itemNames);
        }
        return names;
    }

    public Map<String, String[]> getParameterMap() {
        Map<String, String[]> map = super.getParameterMap();
        if (map.isEmpty() && this.isContentInMultipart() && this.isNotSOAPRequest() && this.isNotCmis()) {
            List<FileItem> items = this.getFileItems();
            map = new HashMap(items.size());
            for (FileItem item : items) {
                String[] value;
                if (!item.isFormField()) continue;
                try {
                    value = new String[]{item.getString(this.getCharacterEncoding())};
                }
                catch (UnsupportedEncodingException ex) {
                    SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)ex);
                    value = new String[]{item.getString()};
                }
                map.put(item.getFieldName(), value);
            }
            map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    public Map<String, String> getParameterSimpleMap() {
        return this.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Arrays.stream((String[])e.getValue()).findFirst().orElse("")));
    }

    public void mergeSelectedItemsInto(Collection<String> selectedIds) {
        this.mergeSelectedItemsInto(selectedIds, "selectedIds", "unselectedIds");
    }

    public void mergeSelectedItemsInto(Collection<String> selectedIds, String selectedParamName, String unselectedParamName) {
        String[] selected = this.getParameterMap().get(selectedParamName);
        String[] unselected = this.getParameterMap().get(unselectedParamName);
        if (selected != null) {
            Arrays.stream(selected).flatMap(i -> Arrays.stream(i.split(","))).forEach(selectedIds::add);
        }
        if (unselected != null) {
            Arrays.stream(unselected).flatMap(i -> Arrays.stream(i.split(","))).forEach(selectedIds::remove);
        }
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (value == null && this.isContentInMultipart() && this.isNotSOAPRequest() && this.isNotCmis()) {
            value = FileUploadUtil.getParameter(this.getFileItems(), (String)name, null, (String)this.getCharacterEncoding());
        }
        return value;
    }

    public boolean isParameterDefined(String name) {
        return StringUtil.isDefined((String)super.getParameter(name));
    }

    public boolean isParameterNotNull(String name) {
        return super.getParameter(name) != null;
    }

    public List<String> getParameterAsList(String parameterName) {
        String[] values = this.getParameterMap().get(parameterName);
        if (values == null) {
            values = new String[]{};
        }
        if (values.length == 1) {
            return Arrays.asList(StringUtils.split((String)values[0], (String)","));
        }
        return Arrays.stream(values).collect(Collectors.toList());
    }

    public RequestFile getParameterAsRequestFile(String parameterName) {
        RequestFile requestFile = null;
        FileItem fileItem = FileUploadUtil.getFile(this.getFileItems(), (String)parameterName);
        if (fileItem != null) {
            requestFile = new RequestFile(fileItem);
        }
        return requestFile;
    }

    public boolean getParameterAsBoolean(String parameterName) {
        return RequestParameterDecoder.asBoolean(this.getParameter(parameterName));
    }

    public List<Boolean> getParameterAsBooleanList(String parameterName) {
        return this.getParameterAsList(parameterName).stream().map(RequestParameterDecoder::asBoolean).collect(Collectors.toList());
    }

    public Long getParameterAsLong(String parameterName) {
        return RequestParameterDecoder.asLong(this.getParameter(parameterName));
    }

    public List<Long> getParameterAsLongList(String parameterName) {
        return this.getParameterAsList(parameterName).stream().map(RequestParameterDecoder::asLong).collect(Collectors.toList());
    }

    public Integer getParameterAsInteger(String parameterName) {
        return RequestParameterDecoder.asInteger(this.getParameter(parameterName));
    }

    public List<Integer> getParameterAsIntegerList(String parameterName) {
        return this.getParameterAsList(parameterName).stream().map(RequestParameterDecoder::asInteger).collect(Collectors.toList());
    }

    public Date getParameterAsDate(String dateParameterName) throws ParseException {
        return RequestParameterDecoder.asDate(this.getParameter(dateParameterName), null, this.getUserLanguage());
    }

    public List<Date> getParameterAsDateList(String dateParameterName) {
        return this.getParameterAsList(dateParameterName).stream().map(p -> {
            try {
                return RequestParameterDecoder.asDate(p, null, this.getUserLanguage());
            }
            catch (ParseException e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    public Date getParameterAsDate(String dateParameterName, String hourParameterName) throws ParseException {
        return RequestParameterDecoder.asDate(this.getParameter(dateParameterName), this.getParameter(hourParameterName), this.getUserLanguage());
    }

    public <E extends Enum<E>> E getParameterAsEnum(String enumValue, Class<E> enumClass) {
        return RequestParameterDecoder.asEnum(this.getParameter(enumValue), enumClass);
    }

    public <E extends Enum<E>> List<E> getParameterAsEnumList(String parameterName, Class<E> enumClass) {
        return this.getParameterAsList(parameterName).stream().map(p -> RequestParameterDecoder.asEnum(p, enumClass)).collect(Collectors.toList());
    }

    public boolean isContentInMultipart() {
        return FileUploadUtil.isRequestMultipart((HttpServletRequest)this);
    }

    public String getCharacterEncoding() {
        String encoding = super.getCharacterEncoding();
        if (StringUtil.isNotDefined((String)encoding)) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    private boolean isNotSOAPRequest() {
        return this.getHeader("SOAPAction") == null && !this.getContentType().contains("soap");
    }

    private boolean isNotCmis() {
        return !this.getRequestURI().contains("cmis");
    }
}

