/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.components.resourcesmanager.model.ResourceStatus;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.util.StringUtil;

@Entity
@Table(name="sc_resources_reservation")
@NamedQueries(value={@NamedQuery(name="reservation.findAllReservationsInRange", query="SELECT reservation FROM Reservation reservation WHERE reservation.instanceId = :instanceId AND reservation.beginDate < :endPeriod  AND reservation.endDate > :startPeriod "), @NamedQuery(name="reservation.findAllReservationsForUserInRange", query="SELECT reservation FROM Reservation reservation WHERE reservation.instanceId = :instanceId AND reservation.userId= :userId AND reservation.beginDate < :endPeriod AND reservation.endDate > :startPeriod "), @NamedQuery(name="reservation.findAllReservationsForUser", query="SELECT reservation FROM Reservation reservation WHERE reservation.instanceId = :instanceId AND reservation.userId= :userId"), @NamedQuery(name="reservation.findAllReservationsForValidation", query="SELECT DISTINCT reservedResource.reservation FROM ReservedResource reservedResource JOIN reservedResource.resource.managers manager WHERE reservedResource.status = 'A' AND manager.id.managerId = :managerId AND reservedResource.reservation.instanceId = :instanceId AND reservedResource.reservation.beginDate < :endPeriod AND reservedResource.reservation.endDate > :startPeriod "), @NamedQuery(name="reservation.findAllReservationsNotRefusedForResourceInRange", query="SELECT DISTINCT reservedResource.reservation FROM ReservedResource reservedResource WHERE reservedResource.resource.id = :resourceId AND reservedResource.status != 'R' AND reservedResource.reservation.beginDate < :endPeriod AND reservedResource.reservation.endDate > :startPeriod "), @NamedQuery(name="reservation.findAllReservationsForCategoryInRange", query="SELECT DISTINCT reservedResource.reservation FROM ReservedResource reservedResource WHERE reservedResource.resource.category.id = :categoryId AND reservedResource.reservation.instanceId = :instanceId AND reservedResource.reservation.beginDate < :endPeriod AND reservedResource.reservation.endDate > :startPeriod "), @NamedQuery(name="reservation.findAllReservationsForUserAndCategoryInRange", query="SELECT DISTINCT reservedResource.reservation FROM ReservedResource reservedResource WHERE reservedResource.resource.category.id = :categoryId AND reservedResource.reservation.instanceId = :instanceId AND reservedResource.reservation.userId = :userId AND reservedResource.reservation.beginDate < :endPeriod AND reservedResource.reservation.endDate > :startPeriod "), @NamedQuery(name="reservation.findAllReservationsForResourceInRange", query="SELECT DISTINCT reservedResource.reservation FROM ReservedResource reservedResource WHERE reservedResource.resource.id = :resourceId AND reservedResource.reservation.instanceId = :instanceId AND reservedResource.reservation.beginDate < :endPeriod AND reservedResource.reservation.endDate > :startPeriod "), @NamedQuery(name="reservation.findAllReservationsForUserAndResourceInRange", query="SELECT DISTINCT reservedResource.reservation FROM ReservedResource reservedResource WHERE reservedResource.resource.id = :resourceId AND reservedResource.reservation.instanceId = :instanceId AND reservedResource.reservation.userId = :userId AND reservedResource.reservation.beginDate < :endPeriod AND reservedResource.reservation.endDate > :startPeriod "), @NamedQuery(name="reservation.findAllReservations", query="SELECT DISTINCT reservation FROM Reservation reservation WHERE reservation.instanceId = :instanceId")})
public class Reservation
extends BasicJpaEntity<Reservation, UniqueLongIdentifier>
implements ResourceStatus {
    private static final long serialVersionUID = 4901854718854856161L;
    @Column(name="evenement", length=128, nullable=false)
    private String event;
    @Column(length=20, nullable=false)
    private String beginDate;
    @Column(length=20, nullable=false)
    private String endDate;
    @Column(length=2000, nullable=true)
    private String reason;
    @Column(length=128, nullable=true)
    private String place;
    @Column
    private int userId;
    @Column(length=20, nullable=false)
    private String creationDate;
    @Column(length=20, nullable=false)
    private String updateDate;
    @Column
    private String instanceId;
    @Column
    private String status;
    @Transient
    private String userName;

    public void performBeforePersist() {
        Date now = new Date();
        this.setCreationDate(now);
        this.setUpdateDate(now);
    }

    public void performBeforeUpdate() {
        this.setUpdateDate(new Date());
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Date getCreationDate() {
        if (StringUtil.isLong((String)this.creationDate)) {
            Date creation = new Date();
            creation.setTime(Long.parseLong(this.creationDate));
            return creation;
        }
        return null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate != null ? String.valueOf(creationDate.getTime()) : null;
    }

    public Long getIdAsLong() {
        return ((UniqueLongIdentifier)this.getNativeId()).getId();
    }

    public String getIdAsString() {
        return this.getId();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public Date getUpdateDate() {
        if (StringUtil.isLong((String)this.updateDate)) {
            Date update = new Date();
            update.setTime(Long.parseLong(this.updateDate));
            return update;
        }
        return null;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = String.valueOf(updateDate.getTime());
    }

    public String getUserId() {
        return String.valueOf(this.userId);
    }

    public void setUserId(String userId) {
        if (StringUtil.isInteger((String)userId)) {
            this.userId = Integer.parseInt(userId);
        }
    }

    public Date getBeginDate() {
        if (StringUtil.isLong((String)this.beginDate)) {
            Date begin = new Date();
            begin.setTime(Long.parseLong(this.beginDate));
            return begin;
        }
        return null;
    }

    public void setBeginDate(Date beginDate) {
        if (beginDate != null) {
            this.beginDate = String.valueOf(beginDate.getTime());
        }
    }

    public Date getEndDate() {
        if (StringUtil.isLong((String)this.endDate)) {
            Date end = new Date();
            end.setTime(Long.parseLong(this.endDate));
            return end;
        }
        return null;
    }

    public void setEndDate(Date endDate) {
        if (endDate != null) {
            this.endDate = String.valueOf(endDate.getTime());
        }
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Reservation() {
    }

    public Reservation(String event, Date beginDate, Date endDate, String reason, String place) {
        this.event = event;
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.reason = reason;
        this.place = place;
    }

    public Reservation(Long id, String event, Date beginDate, Date endDate, String reason, String place, String userId, Date creationDate, Date updateDate, String instanceId) {
        this.setId(Long.toString(id));
        this.event = event;
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.reason = reason;
        this.place = place;
        this.setUserId(userId);
        this.setCreationDate(creationDate);
        this.setUpdateDate(updateDate);
        this.instanceId = instanceId;
    }

    public Reservation(Long id, String event, Date beginDate, Date endDate, String reason, String place, String userId, Date creationDate, Date updateDate, String instanceId, String status) {
        this.setId(Long.toString(id));
        this.event = event;
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.reason = reason;
        this.place = place;
        this.setUserId(userId);
        this.setCreationDate(creationDate);
        this.setUpdateDate(updateDate);
        this.instanceId = instanceId;
        this.status = status;
    }

    public String toString() {
        return "Reservation{id=" + this.getId() + ", event=" + this.event + ", beginDate=" + this.beginDate + ", endDate=" + this.endDate + ", reason=" + this.reason + ", place=" + this.place + ", userId=" + this.userId + ", creationDate=" + this.creationDate + ", updateDate=" + this.updateDate + ", instanceId=" + this.instanceId + ", status=" + this.status + ", userName=" + this.userName + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reservation other = (Reservation)obj;
        EqualsBuilder matcher = new EqualsBuilder();
        matcher.append((Object)this.getId(), (Object)other.getId());
        matcher.append((Object)this.getEvent(), (Object)other.getEvent());
        matcher.append((Object)this.getBeginDate(), (Object)other.getBeginDate());
        matcher.append((Object)this.getEndDate(), (Object)other.getEndDate());
        matcher.append((Object)this.getReason(), (Object)other.getReason());
        matcher.append((Object)this.getPlace(), (Object)other.getPlace());
        matcher.append((Object)this.getUserId(), (Object)other.getUserId());
        matcher.append((Object)this.getInstanceId(), (Object)other.getInstanceId());
        return matcher.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hash = new HashCodeBuilder();
        hash.append((Object)this.getId());
        hash.append((Object)this.getEvent());
        hash.append((Object)this.getBeginDate());
        hash.append((Object)this.getEndDate());
        hash.append((Object)this.getReason());
        hash.append((Object)this.getPlace());
        hash.append((Object)this.getUserId());
        hash.append((Object)this.getInstanceId());
        return hash.toHashCode();
    }

    public boolean isValidated() {
        return "V".equals(this.status);
    }

    public boolean isRefused() {
        return "R".equals(this.status);
    }

    public boolean isValidationRequired() {
        return "A".equals(this.status);
    }
}

