/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.processmanager.record;

import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.processmanager.record.QuestionRecord;

public class QuestionTemplate
implements RecordTemplate {
    private static final String CONTENT = "Content";
    private LocalizationBundle label = null;
    private String language;
    private boolean readonly;

    public QuestionTemplate(String language, boolean readonly) {
        this.label = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.processManager.multilang.processManagerBundle", (String)language);
        this.language = language;
        this.readonly = readonly;
    }

    public String[] getFieldNames() {
        String[] fieldNames = new String[]{CONTENT};
        return fieldNames;
    }

    public FieldTemplate[] getFieldTemplates() {
        try {
            FieldTemplate[] templates = new FieldTemplate[]{this.getFieldTemplate(CONTENT)};
            return templates;
        }
        catch (FormException fe) {
            return new FieldTemplate[0];
        }
    }

    public FieldTemplate getFieldTemplate(String fieldName) throws FormException {
        GenericFieldTemplate fieldTemplate = null;
        fieldTemplate = new GenericFieldTemplate(fieldName, "text");
        fieldTemplate.addLabel(this.label.getString("processManager." + fieldName), this.language);
        if (this.readonly) {
            fieldTemplate.setDisplayerName("simpletext");
        } else {
            fieldTemplate.setDisplayerName("textarea");
            fieldTemplate.setMandatory(true);
            fieldTemplate.setReadOnly(this.readonly);
            fieldTemplate.addParameter("maxLength", "500");
        }
        return fieldTemplate;
    }

    public int getFieldIndex(String fieldName) throws FormException {
        if (fieldName.equals(CONTENT)) {
            return 0;
        }
        return -1;
    }

    public DataRecord getEmptyRecord() throws FormException {
        return new QuestionRecord("");
    }

    public boolean checkDataRecord(DataRecord record) {
        try {
            String value = (String)record.getField(CONTENT).getObjectValue();
            return value != null && value.length() > 0;
        }
        catch (FormException fe) {
            return false;
        }
    }
}

