/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.notification;

import java.util.Collection;
import java.util.HashSet;
import org.silverpeas.components.kmelia.notification.AbstractKmeliaActionPublicationUserNotification;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.StringUtil;

public class KmeliaValidationPublicationUserNotification
extends AbstractKmeliaActionPublicationUserNotification {
    private final String refusalMotive;
    private final String userIdWhoRefuse;

    public KmeliaValidationPublicationUserNotification(NodePK nodePK, PublicationDetail resource, String refusalMotive, String userIdWhoRefuse) {
        super(nodePK, resource, null);
        this.refusalMotive = refusalMotive;
        this.userIdWhoRefuse = userIdWhoRefuse;
    }

    protected String getBundleSubjectKey() {
        if (!StringUtil.isDefined((String)this.refusalMotive)) {
            return "PublicationValidated";
        }
        return "PublicationRefused";
    }

    protected String getTemplateFileName() {
        if (!StringUtil.isDefined((String)this.refusalMotive)) {
            return "notificationValidation";
        }
        return "notificationRefused";
    }

    protected void perform(PublicationDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().setOriginalExtraMessage(this.refusalMotive);
    }

    @Override
    protected void performTemplateData(String language, PublicationDetail resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        template.setAttribute("refusalMotive", (Object)this.refusalMotive);
    }

    protected Collection<String> getUserIdsToNotify() {
        HashSet<String> userIds = new HashSet<String>();
        if (StringUtil.isDefined((String)((PublicationDetail)this.getResource()).getUpdaterId())) {
            userIds.add(((PublicationDetail)this.getResource()).getUpdaterId());
        }
        return userIds;
    }

    @Override
    protected String getSender() {
        return this.userIdWhoRefuse;
    }

    @Override
    protected NotifAction getAction() {
        if (!StringUtil.isDefined((String)this.refusalMotive)) {
            return NotifAction.VALIDATE;
        }
        return NotifAction.REFUSE;
    }
}

