/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.dao;

import java.sql.SQLException;
import java.util.List;
import org.silverpeas.components.kmelia.dao.TopicSearchDao;
import org.silverpeas.components.kmelia.model.MostInterestedQueryVO;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;
import org.silverpeas.core.util.logging.SilverLogger;

@Repository
public class TopicSearchDaoImpl
implements TopicSearchDao {
    private static final String QUERY_GET_LIST_MOST_INTERESTED_QUERY = "count(*) as nb, query FROM sc_kmelia_search WHERE instanceid = ? GROUP BY query, language ORDER BY nb DESC, query";
    private static SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.kmelia.settings.kmeliaSettings");

    @Override
    public List<MostInterestedQueryVO> getMostInterestedSearch(String instanceId) {
        JdbcSqlQuery jdbcSqlQuery = JdbcSqlQuery.createSelect((String)QUERY_GET_LIST_MOST_INTERESTED_QUERY, (Object[])new Object[]{instanceId}).configure(config -> config.withResultLimit(settings.getInteger("kmelia.stats.most.interested.query.limit", 10)));
        ListSlice mostInterestedQueries = null;
        try {
            mostInterestedQueries = jdbcSqlQuery.execute(row -> new MostInterestedQueryVO(row.getString("query"), row.getInt("nb")));
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)this).error("Problem to execute SQL query count(*) as nb, query FROM sc_kmelia_search WHERE instanceid = ? GROUP BY query, language ORDER BY nb DESC, query with intanceId = " + instanceId, (Throwable)e);
        }
        return mostInterestedQueries;
    }
}

