/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.infoletter.service;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import org.silverpeas.components.infoletter.model.InfoLetterPublicationPdC;
import org.silverpeas.components.infoletter.model.InfoLetterService;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.contribution.ContributionLocatorByLocalIdAndType;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;

@Named
public class InfoLetterContributionLocator
implements ContributionLocatorByLocalIdAndType {
    private static final List<String> HANDLED_TYPES = Collections.singletonList("publication");

    public boolean isContributionLocatorOfType(String type) {
        return HANDLED_TYPES.contains(type);
    }

    public Optional<ContributionIdentifier> getContributionIdentifierFromLocalIdAndType(String localId, String type) {
        if ("publication".equals(type)) {
            InfoLetterService service = InfoLetterService.get();
            IdPK pk = new IdPK(localId);
            return Optional.ofNullable(service.getInfoLetterPublication((WAPrimaryKey)pk)).map(InfoLetterPublicationPdC::getIdentifier);
        }
        return Optional.empty();
    }
}

