/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.delegatednews;

import javax.inject.Inject;
import org.silverpeas.components.delegatednews.model.DelegatedNews;
import org.silverpeas.components.delegatednews.service.DelegatedNewsService;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.notification.PublicationEvent;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.util.StringUtil;

@Bean
public class DelegatedPublicationEventListener
extends CDIResourceEventListener<PublicationEvent> {
    @Inject
    private DelegatedNewsService delegatedNewsService;

    public void onUpdate(PublicationEvent event) {
        DelegatedNews delegatedNews;
        PublicationDetail pubDetail = (PublicationDetail)event.getTransition().getAfter();
        if (this.isDelegatedNewsActivated(pubDetail.getInstanceId()) && (delegatedNews = this.delegatedNewsService.getDelegatedNews(pubDetail.getId())) != null) {
            this.delegatedNewsService.updateDelegatedNews(pubDetail.getIdentifier(), pubDetail.getUpdaterId(), pubDetail.getVisibility().getSpecificPeriod().orElse(null));
        }
    }

    public void onDeletion(PublicationEvent event) {
        PublicationDetail pubDetail = (PublicationDetail)event.getTransition().getBefore();
        if (this.isDelegatedNewsActivated(pubDetail.getInstanceId())) {
            this.delegatedNewsService.deleteDelegatedNews(pubDetail.getId());
        }
    }

    private boolean isDelegatedNewsActivated(String componentId) {
        String paramValue = OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentId, "delegatedNews");
        return StringUtil.getBooleanValue((String)paramValue);
    }
}

