/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning;

import java.util.HashMap;
import java.util.Map;
import org.silverpeas.components.datawarning.DataWarningDBDriver;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.XmlSettingBundle;
import org.silverpeas.core.util.logging.SilverLogger;

public final class DataWarningDBDrivers {
    protected static final Map<String, DataWarningDBDriver> allDBDrivers = new HashMap<String, DataWarningDBDriver>();
    protected static DataWarningDBDriver[] sortedDBDrivers = null;
    private static final String XML_SETTING_PATH = "org.silverpeas.dataWarning.settings.dataWarningSettings";

    public DataWarningDBDrivers() {
        this.loadDrivers();
    }

    public void loadDrivers() {
        try {
            XmlSettingBundle xmlConfig = ResourceLocator.getXmlSettingBundle((String)XML_SETTING_PATH);
            String[] driversUniqueIds = xmlConfig.getStringArray("DataWarning-configuration.Drivers");
            sortedDBDrivers = new DataWarningDBDriver[driversUniqueIds.length];
            for (int j = 0; j < driversUniqueIds.length; ++j) {
                XmlSettingBundle.SettingSection section = xmlConfig.getSettingSection(driversUniqueIds[j] + "-configuration");
                DataWarningDBDrivers.sortedDBDrivers[j] = new DataWarningDBDriver(driversUniqueIds[j], section.getString("DriverName"), section.getString("ClassName"), section.getString("Description"), section.getString("JDBCUrl"));
                allDBDrivers.put(driversUniqueIds[j], sortedDBDrivers[j]);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public DataWarningDBDriver[] getDBDrivers() {
        return sortedDBDrivers;
    }

    public DataWarningDBDriver getDBDriver(String driverUniqueId) {
        if (driverUniqueId == null || driverUniqueId.length() <= 0) {
            return sortedDBDrivers[0];
        }
        return allDBDrivers.get(driverUniqueId);
    }
}

