/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception. You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */
package org.silverpeas.components.mailinglist.servlets;

import org.silverpeas.components.mailinglist.service.MailingListServicesProvider;
import org.silverpeas.components.mailinglist.service.model.beans.MailingList;
import org.silverpeas.components.mailinglist.service.model.beans.Message;
import org.silverpeas.components.mailinglist.service.util.OrderBy;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class MailingListProcessor implements MailingListRoutage {

  public static String processMailingList(RestRequest rest,
      HttpServletRequest request) {
    switch (rest.getAction()) {
      case RestRequest.DELETE:
      case RestRequest.UPDATE:
      case RestRequest.FIND:
      default:
        int page = 0;
        if (request.getParameter(CURRENT_PAGE_PARAM) != null) {
          try {
            page = Integer.parseInt(request.getParameter(CURRENT_PAGE_PARAM));
          } catch (NumberFormatException nfex) {
          }
        }
        int year = -1;
        if (rest.getElements().get(CURRENT_YEAR_PARAM) != null) {
          try {
            year = Integer.parseInt(rest.getElements().get(CURRENT_YEAR_PARAM));
          } catch (NumberFormatException nfex) {
            year = -1;
          }
        }
        int month = -1;
        if (rest.getElements().get(CURRENT_MONTH_PARAM) != null) {
          try {
            month = Integer.parseInt(rest.getElements().get(CURRENT_MONTH_PARAM));
          } catch (NumberFormatException nfex) {
            month = -1;
          }
        }
        String id = rest.getElements().get(DESTINATION_LIST);
        MailingList list = MailingListServicesProvider.getMailingListService().findMailingList(id);
        String orderParam = request.getParameter(ORDER_BY_PARAM);
        String ascendantParam = request.getParameter(ORDER_ASC_PARAM);
        boolean asc = false;
        if (orderParam == null) {
          orderParam = "sentDate";
        }
        if (ascendantParam != null) {
          asc = Boolean.valueOf(ascendantParam);
        }
        request.setAttribute(orderParam, !asc);
        OrderBy orderBy = new OrderBy(orderParam, asc);
        List<Message> messages = MailingListServicesProvider.getMessageService()
            .listDisplayableMessages(list, month, year, page, orderBy);
        request.setAttribute(MESSAGES_LIST_ATT, messages);
        int nbPages = MailingListServicesProvider.getMessageService()
            .getNumberOfPagesForDisplayableMessages(list);
        request.setAttribute(NB_PAGE_ATT, nbPages);
        request.setAttribute(CURRENT_PAGE_ATT, page);
        return JSP_BASE + DESTINATION_DISPLAY_LIST;
    }
  }
}
