/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.almanach.workflowextensions;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.components.almanach.workflowextensions.AlmanachTriggerParam;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.Priority;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.DataRecordUtil;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.model.Parameter;
import org.silverpeas.core.workflow.external.impl.ExternalActionImpl;

@Named(value="SendInAlmanachHandler")
public class SendInAlmanach
extends ExternalActionImpl {
    private String role = "unknown";
    private static final String ADMIN_ID = "0";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy hh:mm");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    @Inject
    private OrganizationController organizationController;

    public void execute() {
        this.setRole(this.getEvent().getUserRoleName());
        Parameter almanachParam = this.getTriggerParameter(AlmanachTriggerParam.APPLICATION_ID.getParameterName());
        String componentInstanceId = almanachParam.getValue();
        Period eventPeriod = this.getEventPeriod();
        if (this.isMandatoryTriggerParamValid(almanachParam, eventPeriod)) {
            Calendar almanach = (Calendar)Calendar.getByComponentInstanceId((String)componentInstanceId).getMainCalendar().orElseThrow(() -> new IllegalStateException(SilverpeasExceptionMessages.unknown((String)"main calendar on", (Object)componentInstanceId)));
            CalendarEvent event = CalendarEvent.on((Period)eventPeriod).withTitle(this.getFolderValueFromTriggerParam(AlmanachTriggerParam.EVENT_NAME)).withDescription(this.getFolderValueFromTriggerParam(AlmanachTriggerParam.EVENT_DESCRIPTION));
            event.setLocation(this.getFolderValueFromTriggerParam(AlmanachTriggerParam.PLACE));
            event.getAttributes().set("externalUrl", this.getFolderValueFromTriggerParam(AlmanachTriggerParam.EVENT_URL));
            boolean priority = StringUtil.getBooleanValue((String)this.getFolderValueFromTriggerParam(AlmanachTriggerParam.PRIORITY));
            if (priority) {
                event.withPriority(Priority.HIGH);
            }
            event.planOn(almanach);
        } else {
            StringBuilder warnMsg = new StringBuilder();
            warnMsg.append("Workflow export event problem :");
            if (!StringUtil.isDefined((String)componentInstanceId) || !this.getOrganizationController().isComponentExist(componentInstanceId)) {
                warnMsg.append("You must set a correct trigger parameter tp_almanachId.");
            }
            if (eventPeriod == null) {
                warnMsg.append("You must set a correct trigger parameter tp_startDate.");
            }
            SilverLogger.getLogger((Object)((Object)this)).warn(warnMsg.toString(), new Object[0]);
        }
    }

    private boolean isMandatoryTriggerParamValid(Parameter almanachParam, Period eventPeriod) {
        return almanachParam != null && StringUtil.isDefined((String)almanachParam.getValue()) && this.getOrganizationController().isComponentExist(almanachParam.getValue()) && eventPeriod != null;
    }

    private Period getEventPeriod() {
        String startDayValue = this.getFolderValueFromTriggerParam(AlmanachTriggerParam.START_DATE);
        String endDayValue = this.getFolderValueFromTriggerParam(AlmanachTriggerParam.END_DATE);
        if (startDayValue != null) {
            String startHourValue = this.getFolderValueFromTriggerParam(AlmanachTriggerParam.START_HOUR);
            String endHourValue = this.getFolderValueFromTriggerParam(AlmanachTriggerParam.END_HOUR);
            try {
                Comparable<ChronoLocalDate> start = StringUtil.isValidHour((String)startHourValue) ? OffsetDateTime.parse(startDayValue + " " + startHourValue, DATE_TIME_FORMATTER) : LocalDate.parse(startDayValue, DATE_FORMATTER);
                Object end = endDayValue != null ? (StringUtil.isValidHour((String)endHourValue) ? OffsetDateTime.parse(endDayValue + " " + endHourValue, DATE_TIME_FORMATTER) : LocalDate.parse(endDayValue, DATE_FORMATTER).plusDays(1L)) : (StringUtil.isValidHour((String)endHourValue) ? OffsetDateTime.parse(startDayValue + " " + endHourValue, DATE_TIME_FORMATTER) : start.plus(1L, ChronoUnit.DAYS));
                return Period.between(start, (Temporal)end);
            }
            catch (DateTimeParseException e) {
                SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)e);
            }
        }
        return null;
    }

    private String getFolderValueFromTriggerParam(AlmanachTriggerParam almanachParam) {
        return this.evaluateFolderValues(this.retrieveTriggerParamValue(almanachParam));
    }

    private String retrieveTriggerParamValue(AlmanachTriggerParam almanachParam) {
        String triggerParamValue = "";
        Parameter triggerParam = this.getTriggerParameter(almanachParam.getParameterName());
        if (triggerParam != null) {
            triggerParamValue = triggerParam.getValue();
        }
        return triggerParamValue;
    }

    private String evaluateFolderValues(String triggerParamValue) {
        String evaluateValue = triggerParamValue;
        if (StringUtil.isDefined((String)triggerParamValue)) {
            try {
                evaluateValue = DataRecordUtil.applySubstitution((String)triggerParamValue, (DataRecord)this.getProcessInstance().getAllDataRecord(this.getRole(), "fr"), (String)"fr");
            }
            catch (WorkflowException e) {
                SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            }
        }
        return evaluateValue;
    }

    private String getRole() {
        return this.role;
    }

    private void setRole(String role) {
        this.role = role;
    }

    private OrganizationController getOrganizationController() {
        return this.organizationController;
    }
}

